/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms.ctbl;

import org.maachang.dao.dbms.DbUtil;
import org.maachang.dao.dbms.ctbl.Table;
import org.maachang.engine.util.StringUtil;

class OneEntry {
    private String name = null;
    private int type = -1;
    private static final String FIELD_NAME = "$(FIELD)";
    private static final String LFIELD_NAME = "$(LFIELD)";
    private static final String TYPE_NAME = "$(TYPE)";
    private static final String[] METHOD_TEMPLATE = new String[]{"/**", " * $(FIELD) \u3092\u8a2d\u5b9a\u3057\u307e\u3059.", " * <BR>", " * @param $(LFIELD) $(FIELD) \u3092\u8a2d\u5b9a\u3057\u307e\u3059.", " */", "public void set$(FIELD)( $(TYPE) $(LFIELD) ) {", "    this.$(LFIELD) = $(LFIELD) ;", "}", "", "/**", " * $(FIELD) \u3092\u53d6\u5f97\u3057\u307e\u3059.", " * <BR>", " * @return $(TYPE) $(FIELD) \u304c\u8fd4\u3055\u308c\u307e\u3059.", " */", "public $(TYPE) get$(FIELD)() {", "    return this.$(LFIELD) ;", "}", ""};
    private static final String[] FIELD_TEMPLATE = new String[]{"/**", " * $(FIELD)\u60c5\u5831.", " */", "private $(TYPE) $(LFIELD) = null ;", ""};

    private OneEntry() {
    }

    public OneEntry(String name, String fieldType) {
        int entryType = OneEntry.getFieldType(fieldType);
        if (entryType != -1) {
            this.name = name;
            this.type = entryType;
        }
    }

    public static final int getFieldType(String fieldType) {
        int entryType = -1;
        fieldType = fieldType.trim().toLowerCase();
        int len = Table.VALUE_TYPES.length;
        int i = 0;
        while (i < len) {
            if (Table.VALUE_TYPES[i].equals(fieldType)) {
                entryType = i;
                break;
            }
            ++i;
        }
        return entryType;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public String getMethod() {
        return this.convert(METHOD_TEMPLATE);
    }

    public String getField() {
        return this.convert(FIELD_TEMPLATE);
    }

    private String convert(String[] template) {
        if (this.name == null || this.type == -1) {
            return "";
        }
        String jname = DbUtil.convertDBNameByJavaName(true, this.name);
        String jnameLow = String.valueOf(jname.substring(0, 1).toLowerCase()) + jname.substring(1, jname.length());
        String jtype = Table.VALUE_JAVA_TYPES[this.type];
        StringBuilder buf = new StringBuilder(1024);
        int len = template.length;
        int i = 0;
        while (i < len) {
            buf.append("    ").append(template[i]).append("\r\n");
            ++i;
        }
        String ret = buf.toString();
        ret = StringUtil.changeString(ret, FIELD_NAME, jname);
        ret = StringUtil.changeString(ret, LFIELD_NAME, jnameLow);
        return StringUtil.changeString(ret, TYPE_NAME, jtype);
    }
}

