/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms.ctbl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.maachang.dao.dbms.DbUtil;
import org.maachang.dao.dbms.ctbl.OneEntry;
import org.maachang.engine.util.FileUtil;
import org.maachang.engine.util.StringUtil;

public class CreateEntry {
    private String packageName = null;
    private String modelName = null;
    private ArrayList<OneEntry> params = null;
    private static final String MODEL_NAME = "$(MODEL)";
    private static final String PACKAGE_NAME = "$(PACKAGE)";
    private static final String TIMESTAMP_NAME = "$(TIMESTAMP)";
    private static final String MODELS_NAME = "$(METHODS)";
    private static final String[] ENTRY_TEMPLATE = new String[]{"package $(PACKAGE).entry ;", "", "/**", " * $(MODEL) \u60c5\u5831.", " * ", " * @version $(TIMESTAMP).", " * @author MaaEngine(CreateEntry).", " * @since MaaEngine.", " */", "public class $(MODEL) {", "$(METHODS)", "}"};
    private static final String[] DAO_TEMPLATE = new String[]{"package $(PACKAGE).dao ;", "", "import $(PACKAGE).entry.$(MODEL) ;", "import org.maachang.dao.Dao ;", "", "/**", " * $(MODEL) Dao\u60c5\u5831.", " * ", " * @version $(TIMESTAMP).", " * @author MaaEngine(CreateEntry).", " * @since MaaEngine.", " */", "public class $(MODEL)Dao extends Dao<$(MODEL)> {", "    /**", "     * \u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf.", "     */", "    public $(MODEL)Dao() throws Exception {", "        super( $(MODEL).class ) ;", "    }", "    ", "}"};

    private CreateEntry() {
    }

    public CreateEntry(String packageName, String modelName) {
        this.packageName = packageName;
        this.modelName = DbUtil.convertJavaNameByDBName(modelName);
        this.params = new ArrayList();
    }

    public static final int getFieldType(String fieldType) {
        return OneEntry.getFieldType(fieldType);
    }

    public void add(String name, String fieldType) {
        if (OneEntry.getFieldType(fieldType) != -1) {
            OneEntry entry = new OneEntry(name, fieldType);
            this.params.add(entry);
        }
    }

    public void getEntryFileOut(String baseDir) throws Exception {
        String output = this.getDir(false, baseDir);
        String dir = output.substring(0, output.length() - FileUtil.getFileName(output).length());
        if (!FileUtil.isDirExists(dir)) {
            FileUtil.mkdirs(dir);
        }
        String out = this.getMethodFile();
        FileUtil.setFileByString(output, true, out, "UTF8");
    }

    public void getDaoFileOut(String baseDir) throws Exception {
        String output = this.getDir(true, baseDir);
        String dir = output.substring(0, output.length() - FileUtil.getFileName(output).length());
        if (!FileUtil.isDirExists(dir)) {
            FileUtil.mkdirs(dir);
        }
        String out = this.getDaoFile();
        FileUtil.setFileByString(output, true, out, "UTF8");
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getModelName() {
        return this.modelName;
    }

    public int getParamsSize() {
        return this.params.size();
    }

    public String getDir(boolean mode, String baseDir) throws Exception {
        String x;
        String javaModelName = DbUtil.convertDBNameByJavaName(true, this.modelName);
        if (!baseDir.endsWith("\\") && !baseDir.endsWith("/")) {
            baseDir = String.valueOf(baseDir) + "/";
        }
        if ((x = StringUtil.changeString(this.packageName, ".", "/")).startsWith("/")) {
            x = x.substring(1, x.length());
        }
        x = !mode ? String.valueOf(baseDir) + x + "/" + "entry/" + javaModelName + ".java" : String.valueOf(baseDir) + x + "/" + "dao/" + javaModelName + "Dao.java";
        return FileUtil.getFullPath(x);
    }

    private String getMethodFile() {
        StringBuilder buf = new StringBuilder(4096);
        int len = this.params.size();
        int i = 0;
        while (i < len) {
            buf.append(this.params.get(i).getField());
            ++i;
        }
        i = 0;
        while (i < len) {
            buf.append(this.params.get(i).getMethod());
            ++i;
        }
        String methods = buf.toString();
        buf = null;
        return this.convert(ENTRY_TEMPLATE, methods);
    }

    private String getDaoFile() {
        return this.convert(DAO_TEMPLATE, null);
    }

    private String convert(String[] template, String methods) {
        if (template == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(4096);
        int len = template.length;
        int i = 0;
        while (i < len) {
            buf.append(template[i]).append("\r\n");
            ++i;
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy/MM/dd");
        String timestamp = fmt.format(new Date());
        fmt = null;
        String ret = buf.toString();
        ret = StringUtil.changeString(ret, MODEL_NAME, DbUtil.convertDBNameByJavaName(true, this.modelName));
        ret = StringUtil.changeString(ret, PACKAGE_NAME, this.packageName);
        ret = StringUtil.changeString(ret, TIMESTAMP_NAME, timestamp);
        if (methods != null) {
            ret = StringUtil.changeString(ret, MODELS_NAME, methods);
        }
        return ret;
    }
}

