/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.maachang.dao.dbms.DbUtil;
import org.maachang.dao.dbms.ExecutionDao;
import org.maachang.dao.dbms.MetaColumn;
import org.maachang.dao.dbms.Record;
import org.maachang.engine.servlet.GlobalInfo;
import org.maachang.engine.servlet.LocalInfo;
import org.maachang.engine.util.Reflect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Dao<T> {
    private Class entryType = null;
    private String model = null;
    private MetaColumn meta = null;

    public Dao() {
        throw new UnsupportedOperationException("\u3053\u306e\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u306f\u975e\u30b5\u30dd\u30fc\u30c8\u3067\u3059");
    }

    protected Dao(Class<T> type) throws Exception {
        if (type == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        Record rc = GlobalInfo.getRecordFactory().getRecord();
        try {
            this.entryType = type;
            this.model = Dao.modelName(type);
            this.meta = Dao.getMetaColumn(rc, this.model);
            rc.close();
            rc = null;
        }
        finally {
            if (rc != null) {
                try {
                    rc.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected Dao(Class<T> type, Record record) throws Exception {
        if (type == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.entryType = type;
        this.model = Dao.modelName(type);
        this.meta = Dao.getMetaColumn(record, this.model);
    }

    protected void close() throws Exception {
        this.getRecord().close();
    }

    protected boolean commit() throws Exception {
        return this.getRecord().commit();
    }

    protected boolean rollback() throws Exception {
        return this.getRecord().rollback();
    }

    public T save(T o) throws Exception {
        boolean idFlag;
        this.initCheck();
        if (o == null) {
            throw new IllegalArgumentException("\u4fdd\u5b58\u5bfe\u8c61\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        Record record = this.getRecord();
        if (this.checkEntry(record, idFlag = ExecutionDao.isSequence(this.meta), o)) {
            StringBuilder buf = new StringBuilder();
            buf.append("update ").append(this.meta.getTable()).append(" set ");
            int len = this.meta.size();
            int cnt = 0;
            ArrayList<Object> pms = new ArrayList<Object>();
            int i = 0;
            while (i < len) {
                String column = this.meta.getColumnName(i);
                if (!"id".equals(column)) {
                    Object value = null;
                    if ("update_time".equals(column)) {
                        value = new Timestamp(System.currentTimeMillis());
                        Reflect.executionMethod(this.convertMethodName("set", column), o, value);
                    } else {
                        try {
                            value = Reflect.executionMethod(this.convertMethodName("get", column), o);
                        }
                        catch (Exception e) {
                            value = null;
                        }
                        if (value == null) {
                            try {
                                value = Reflect.executionMethod(this.convertMethodName("is", column), o);
                            }
                            catch (Exception e) {
                                value = null;
                            }
                        }
                    }
                    if (value != null) {
                        if (cnt != 0) {
                            buf.append(",");
                        }
                        buf.append(column).append("=").append("?");
                        pms.add(value);
                        ++cnt;
                    }
                }
                ++i;
            }
            buf.append(" where id=?");
            if (pms.size() <= 0) {
                throw new IllegalArgumentException("\u4fdd\u5b58\u5bfe\u8c61\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u5168\u3066NULL\u3067\u3059");
            }
            String sql = buf.toString();
            buf = null;
            Object id = Reflect.executionMethod("getId", o);
            pms.add(id);
            ExecutionDao.execution(null, null, record, this.entryType, this.model, this.meta, sql, -1, -1, pms);
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append("insert into ").append(this.meta.getTable()).append(" (");
            int len = this.meta.size();
            ArrayList<Object> pms = new ArrayList<Object>();
            if (idFlag && record.isSequence()) {
                pms.add(new Object());
                buf.append("id");
                if (len != 1) {
                    buf.append(",");
                }
            }
            int cnt = 0;
            int i = 0;
            while (i < len) {
                String column = this.meta.getColumnName(i);
                if (!"id".equals(column)) {
                    Object value = null;
                    if ("create_time".equals(column) || "update_time".equals(column)) {
                        value = new Timestamp(System.currentTimeMillis());
                        Reflect.executionMethod(this.convertMethodName("set", column), o, value);
                    } else {
                        try {
                            value = Reflect.executionMethod(this.convertMethodName("get", column), o);
                        }
                        catch (Exception e) {
                            value = null;
                        }
                        if (value == null) {
                            try {
                                value = Reflect.executionMethod(this.convertMethodName("is", column), o);
                            }
                            catch (Exception e) {
                                value = null;
                            }
                        }
                    }
                    if (cnt != 0) {
                        buf.append(",");
                    }
                    buf.append(column);
                    if (value == null) {
                        pms.add(null);
                    } else {
                        pms.add(value);
                    }
                    ++cnt;
                }
                ++i;
            }
            buf.append(") values (");
            i = 0;
            while (i < len) {
                if (i != 0) {
                    buf.append(",");
                }
                buf.append("?");
                ++i;
            }
            buf.append(")");
            String sql = buf.toString();
            Long[] resId = new Long[1];
            ExecutionDao.execution(null, resId, record, this.entryType, this.model, this.meta, sql, -1, -1, pms);
            if (resId[0] != null) {
                Reflect.executionMethod("setId", o, resId[0]);
            }
        }
        return o;
    }

    public void update(String set, Object ... params) throws Exception {
        this.initCheck();
        if (set == null || (set = set.trim()).length() <= 0) {
            throw new IllegalArgumentException("set\u5f15\u6570\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        StringBuilder buf = new StringBuilder();
        if (!set.toLowerCase().startsWith("set ")) {
            buf.append("update ").append(this.meta.getTable()).append(" set ").append(set);
        } else {
            buf.append("update ").append(this.meta.getTable()).append(" ").append(set);
        }
        String sql = buf.toString();
        buf = null;
        if (ExecutionDao.isUpdateTime(this.meta)) {
            boolean[] addFlag = new boolean[1];
            sql = Dao.addUpdateTime(addFlag, sql);
            if (addFlag[0]) {
                params = Dao.addUpdateTimeParam(params);
            }
        }
        ExecutionDao.execution(null, null, this.getRecord(), this.entryType, this.model, this.meta, sql, -1, -1, params);
    }

    public void delete(T o) throws Exception {
        this.initCheck();
        if (o == null) {
            throw new IllegalArgumentException("\u524a\u9664\u5bfe\u8c61\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (ExecutionDao.isSequence(this.meta)) {
            StringBuilder buf = new StringBuilder();
            buf.append("delete from ").append(this.meta.getTable()).append(" where id=?;");
            Object id = Reflect.executionMethod("getId", o);
            if (o == null) {
                throw new IllegalArgumentException("ID\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            String sql = buf.toString();
            buf = null;
            ExecutionDao.execution(null, null, this.getRecord(), this.entryType, this.model, this.meta, sql, -1, -1, new Object[]{id});
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append("delete from ").append(this.meta.getTable()).append(" where ");
            int len = this.meta.size();
            ArrayList<Object> pms = new ArrayList<Object>();
            int i = 0;
            while (i < len) {
                if (i != 0) {
                    buf.append(" and ");
                }
                String column = this.meta.getColumnName(i);
                Object value = null;
                try {
                    value = Reflect.executionMethod(this.convertMethodName("get", column), o);
                }
                catch (Exception e) {
                    value = null;
                }
                if (value == null) {
                    try {
                        value = Reflect.executionMethod(this.convertMethodName("is", column), o);
                    }
                    catch (Exception e) {
                        value = null;
                    }
                }
                if (value == null) {
                    buf.append(column).append(" is null");
                } else {
                    buf.append(column).append("=?");
                    pms.add(value);
                }
                ++i;
            }
            buf.append(";");
            if (pms.size() <= 0) {
                pms = null;
            }
            String sql = buf.toString();
            buf = null;
            ExecutionDao.execution(null, null, this.getRecord(), this.entryType, this.model, this.meta, sql, -1, -1, pms);
        }
    }

    public void delete(String where, Object ... params) throws Exception {
        this.initCheck();
        if (where == null || (where = where.trim()).length() <= 0) {
            throw new IllegalArgumentException("where\u5f15\u6570\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        StringBuilder buf = new StringBuilder();
        buf.append("delete from ").append(this.meta.getTable()).append(" ").append(where);
        String sql = buf.toString();
        buf = null;
        ExecutionDao.execution(null, null, this.getRecord(), this.entryType, this.model, this.meta, sql, -1, -1, params);
    }

    public List<T> find(String where, Object ... params) throws Exception {
        return this.find(where, -1, -1, params);
    }

    public List<T> find(String where, int offset, int limit, Object ... params) throws Exception {
        this.initCheck();
        String sql = null;
        if (where == null || (where = where.trim()).length() <= 0) {
            sql = "select * from " + this.meta.getTable();
            params = null;
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append("select * from ").append(this.meta.getTable()).append(" ").append(where);
            sql = buf.toString();
            buf = null;
        }
        ArrayList ret = new ArrayList();
        ExecutionDao.execution(ret, null, this.getRecord(), this.entryType, this.model, this.meta, sql, offset, limit, params);
        return ret;
    }

    public T findFirst() throws Exception {
        List<T> res = this.find((String)null, 0, 1, (Object[])null);
        if (res != null && res.size() > 0) {
            return res.get(0);
        }
        return null;
    }

    public T findFirst(String where, Object ... params) throws Exception {
        List<T> res = this.find(where, 0, 1, params);
        if (res != null && res.size() > 0) {
            return res.get(0);
        }
        return null;
    }

    public List<T> findAll() throws Exception {
        return this.findAll(-1, -1);
    }

    public List<T> findAll(int offset, int limit) throws Exception {
        this.initCheck();
        String sql = "select * from " + this.meta.getTable() + ";";
        ArrayList ret = new ArrayList();
        ExecutionDao.execution(ret, null, this.getRecord(), this.entryType, this.model, this.meta, sql, offset, limit, null);
        return ret;
    }

    public int count() throws Exception {
        return this.count(null, null);
    }

    public int count(String where, Object ... params) throws Exception {
        this.initCheck();
        String sql = null;
        if (where == null || (where = where.trim()).length() <= 0) {
            sql = "select count(*) from " + this.meta.getTable();
            params = null;
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append("select count(*) from ").append(this.meta.getTable()).append(" ").append(where);
            sql = buf.toString();
            buf = null;
        }
        return ExecutionDao.execution(null, null, this.getRecord(), this.entryType, this.model, this.meta, sql, -1, -1, params);
    }

    protected Record getRecord() {
        return LocalInfo.getRecord();
    }

    private void initCheck() throws Exception {
        if (this.entryType == null || this.model == null || this.meta == null) {
            throw new IOException("\u521d\u671f\u5316\u51e6\u7406\u304c\u884c\u308f\u308c\u3066\u3044\u306a\u3044\u304b\u4e0d\u6b63\u3067\u3059");
        }
    }

    private boolean checkEntry(Record record, boolean idFlag, T entry) throws Exception {
        if (!idFlag) {
            return false;
        }
        Object value = Reflect.executionMethod("getId", entry);
        if (value == null) {
            return false;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("select count(*) from ").append(DbUtil.convertJavaNameByDBName(this.model)).append(" where id=?;");
        String sql = buf.toString();
        buf = null;
        ResultSet rs = null;
        try {
            boolean ret = false;
            rs = record.executeQuery(sql, new Object[]{value});
            if (rs != null) {
                if (rs.next()) {
                    ret = true;
                }
                rs.close();
                rs = null;
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String convertMethodName(String type, String column) {
        String method = DbUtil.convertDBNameByJavaName(false, column);
        return type + method.substring(0, 1).toUpperCase() + method.substring(1, method.length());
    }

    private static final String modelName(Class o) {
        String name = o.getName();
        int p = name.lastIndexOf(".");
        if (p != -1) {
            return name.substring(p + 1, name.length());
        }
        return null;
    }

    private static final MetaColumn getMetaColumn(Record record, String model) throws Exception {
        return record.getMetaColumn(DbUtil.convertJavaNameByDBName(model));
    }

    private static final String addUpdateTime(boolean[] addFlag, String sql) throws Exception {
        addFlag[0] = false;
        String lower = sql.toLowerCase();
        int s = lower.indexOf(" set ");
        int e = lower.indexOf(" where ");
        if (s == -1) {
            return sql;
        }
        if (e == -1) {
            e = lower.length();
        }
        int x = lower.indexOf(" update_time", s += " set ".length());
        int y = lower.indexOf(",update_time", s);
        if (x == -1 || x > y) {
            x = y;
        }
        lower = null;
        if (x == -1 || x > e) {
            sql = sql.substring(0, s) + "update_time" + " =?, " + sql.substring(s, sql.length());
            addFlag[0] = true;
        }
        return sql;
    }

    private static final Object[] addUpdateTimeParam(Object[] params) throws Exception {
        Object[] ret = null;
        if (params == null || params.length <= 0) {
            ret = new Object[1];
        } else {
            int len = params.length;
            ret = new Object[len + 1];
            System.arraycopy(params, 0, ret, 1, len);
        }
        ret[0] = new Timestamp(System.currentTimeMillis());
        return ret;
    }
}

