/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.engine.util;

import java.io.ByteArrayOutputStream;

public class URLDecode {
    private static final String DEFAULT_CHARSET = "UTF8";

    public static final String convert(String url) {
        return URLDecode.convert(url, null);
    }

    public static final String convert(String url, String charset) {
        if (url == null || (url = url.trim()).length() <= 0) {
            return null;
        }
        if (charset == null || (charset = charset.trim()).length() <= 0) {
            charset = DEFAULT_CHARSET;
        }
        String ret = url;
        try {
            int len = url.length();
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            int i = 0;
            while (i < len) {
                char c = url.charAt(i);
                if (c == '%') {
                    ba.write(URLDecode.hexChar(url.charAt(i + 1)) << 4 | URLDecode.hexChar(url.charAt(i + 2)));
                    i += 2;
                } else if (c == '+') {
                    ba.write(32);
                } else {
                    ba.write(c & 0xFF);
                }
                ++i;
            }
            ret = new String(ba.toByteArray(), charset);
            ba.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    private static final int hexChar(char c) throws Exception {
        int ret = 0;
        if (c >= '0' && c <= '9') {
            ret = c - 48 & 0xF;
        } else if (c >= 'a' && c <= 'f') {
            ret = (c - 97 & 0xF) + 10;
        } else if (c >= 'A' && c <= 'F') {
            ret = (c - 65 & 0xF) + 10;
        } else {
            throw new Exception("16\u9032[" + c + "]\u6570\u5024\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
        }
        return ret;
    }
}

