/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.engine.util;

public class FnvHash {
    private static final long FNV_32_CODE = 2166136261L;
    private static final long FNV_64_CODE = -3750763034362895579L;

    public static int fnv32(String key) {
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            byte[] b = key.getBytes("UTF8");
            int len = b.length;
            long ret = 2166136261L;
            int i = 0;
            while (i < len) {
                ret += (ret << 1) + (ret << 4) + (ret << 7) + (ret << 8) + (ret << 24);
                ret ^= (long)b[i];
                ++i;
            }
            return (int)(ret & 0xFFFFFFFFL);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int fnv32a(String key) {
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            byte[] b = key.getBytes("UTF8");
            int len = b.length;
            long ret = 2166136261L;
            int i = 0;
            while (i < len) {
                ret ^= (long)b[i];
                ret += (ret << 1) + (ret << 4) + (ret << 7) + (ret << 8) + (ret << 24);
                ++i;
            }
            return (int)(ret & 0xFFFFFFFFL);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static long fnv64(String key) {
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            byte[] b = key.getBytes("UTF8");
            int len = b.length;
            long ret = -3750763034362895579L;
            int i = 0;
            while (i < len) {
                ret += (ret << 1) + (ret << 4) + (ret << 5) + (ret << 7) + (ret << 8) + (ret << 40);
                ret ^= (long)b[i];
                ++i;
            }
            return ret;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static long fnv64a(String key) {
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            byte[] b = key.getBytes("UTF8");
            int len = b.length;
            long ret = -3750763034362895579L;
            int i = 0;
            while (i < len) {
                ret ^= (long)b[i];
                ret += (ret << 1) + (ret << 4) + (ret << 5) + (ret << 7) + (ret << 8) + (ret << 40);
                ++i;
            }
            return ret;
        }
        catch (Exception exception) {
            return 0L;
        }
    }
}

