/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.engine.servlet;

import java.util.Hashtable;
import org.maachang.engine.servlet.PageSession;
import org.maachang.engine.servlet.PageSessionChild;
import org.maachang.engine.servlet.PageSessionMonitor;
import org.maachang.engine.util.RandomUtil;

public class PageSessionManager {
    public static final int RANDOM_SIZE = 48;
    private PageSessionMonitor monitor = null;

    private PageSessionManager() {
    }

    public PageSessionManager(long time) {
        this.monitor = new PageSessionMonitor(time);
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    protected void destroy() {
        if (this.monitor != null) {
            this.monitor.clear();
        }
        this.monitor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String createSession() {
        String ret = null;
        Hashtable<String, PageSessionChild> man = this.monitor.getManager();
        if (man == null) {
            return null;
        }
        while (true) {
            ret = RandomUtil.randomString(48, true, true, true);
            Hashtable<String, PageSessionChild> hashtable = man;
            synchronized (hashtable) {
                if (man.get(ret) == null) {
                    man.put(ret, new PageSessionChild(ret));
                    break;
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String createSession(String sessionId) {
        if (sessionId == null || (sessionId = sessionId.trim()).length() != 48) {
            return this.createSession();
        }
        Hashtable<String, PageSessionChild> man = this.monitor.getManager();
        if (man == null) {
            return null;
        }
        String ret = null;
        Hashtable<String, PageSessionChild> hashtable = man;
        synchronized (hashtable) {
            if (man.get(sessionId) == null) {
                man.put(sessionId, new PageSessionChild(sessionId));
                ret = sessionId;
            } else {
                ret = this.createSession();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PageSession getSession(String sessionId) {
        if (sessionId == null || (sessionId = sessionId.trim()).length() != 48) {
            return null;
        }
        Hashtable<String, PageSessionChild> man = this.monitor.getManager();
        if (man == null) {
            return null;
        }
        PageSessionChild ret = null;
        Hashtable<String, PageSessionChild> hashtable = man;
        synchronized (hashtable) {
            ret = man.get(sessionId);
            if (ret != null) {
                ret.update();
            }
        }
        return ret;
    }

    public synchronized long getTimeout() {
        return this.monitor.getTimeout();
    }
}

