/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.engine.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.dao.dbms.Record;
import org.maachang.engine.Action;
import org.maachang.engine.servlet.ConvertHttpParams;
import org.maachang.engine.servlet.DiContainer;
import org.maachang.engine.servlet.GlobalInfo;
import org.maachang.engine.servlet.NamingByObjectManager;
import org.maachang.engine.servlet.PageSession;
import org.maachang.engine.servlet.ParameterImpl;
import org.maachang.engine.servlet.RequestWrapper;
import org.maachang.engine.servlet.ResultMessageImpl;
import org.maachang.engine.servlet.ThreadLocalParam;
import org.maachang.engine.servlet.Validate;
import org.maachang.engine.util.FileUtil;
import org.maachang.engine.util.Reflect;
import org.maachang.engine.util.SequenceSync;
import org.maachang.engine.util.StringUtil;

public class ActionServlet
extends HttpServlet {
    private static final long serialVersionUID = 3853007460537014586L;
    protected static final Log LOG = LogFactory.getLog(ActionServlet.class);
    public static final String INNER_PAGE_SESSION = "_INNER_SESSION";
    public static final String REFERER = "Referer";
    public static final String SEQUENCE_ID_ATTRIBUTE_NAME = "_SEQUENCE_ID";
    private static final String DEFAULT_ERROR_MESSAGE = "\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f";
    protected static final String DEFAULT_ERROR_PAGE_NAME = "/error.html";
    private static final String ACTION_PACKAGE = "actionPackage";
    private static final String BEAN_PACKAGE = "formPackage";
    private static final String PLUS_NAME = "plus";
    private static final String ERROR_PAGE_NAME = "errorPage";
    private String actionPackage = null;
    private String formPackage = null;
    private String plusName = null;
    private String errorPage = null;
    private final SequenceSync sequence = new SequenceSync();

    public void init(ServletConfig cfg) throws ServletException {
        LOG.info((Object)("# actionPackage:" + cfg.getInitParameter(ACTION_PACKAGE)));
        LOG.info((Object)("# formPackage:" + cfg.getInitParameter(BEAN_PACKAGE)));
        LOG.info((Object)("# plusName:" + cfg.getInitParameter(PLUS_NAME)));
        LOG.info((Object)("# errorPage:" + cfg.getInitParameter(ERROR_PAGE_NAME)));
        this.actionPackage = cfg.getInitParameter(ACTION_PACKAGE);
        this.formPackage = cfg.getInitParameter(BEAN_PACKAGE);
        this.plusName = cfg.getInitParameter(PLUS_NAME);
        this.errorPage = cfg.getInitParameter(ERROR_PAGE_NAME);
        if (!this.actionPackage.endsWith(".")) {
            this.actionPackage = String.valueOf(this.actionPackage) + ".";
        }
        if (!this.formPackage.endsWith(".")) {
            this.formPackage = String.valueOf(this.formPackage) + ".";
        }
        if (!this.plusName.startsWith(".")) {
            this.plusName = "." + this.plusName;
        }
        if (this.errorPage == null || (this.errorPage = this.errorPage.trim()).length() <= 0) {
            this.errorPage = DEFAULT_ERROR_PAGE_NAME;
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String forwardURL = null;
        try {
            ActionServlet.setAttributeMap(request);
            request = new RequestWrapper(this.sequence.getId(), (HttpServletRequest)request);
            String acName = this.getActionName((HttpServletRequest)request);
            Action action = this.getAction(acName);
            acName = null;
            Object formObject = action.getFormObject();
            if (formObject == null) {
                String foName = this.getFormName((HttpServletRequest)request);
                formObject = this.getForm(foName);
                foName = null;
            }
            Record record = null;
            String result = null;
            ResultMessageImpl resultAction = new ResultMessageImpl();
            try {
                try {
                    Validate validate;
                    PageSession session;
                    ThreadLocalParam.getInstance().put("REQUEST_LOCAL_NAME", request);
                    ThreadLocalParam.getInstance().put("RESPONSE_LOCAL_NAME", response);
                    record = GlobalInfo.getRecordFactory().getRecord();
                    ThreadLocalParam.getInstance().put("RECORD_LOCAL_NAME", record);
                    String innerSessionKey = (String)request.getAttribute(INNER_PAGE_SESSION);
                    if ("POST".equals(request.getMethod()) && innerSessionKey != null && GlobalInfo.getPageSessionManager() != null && (session = GlobalInfo.getPageSessionManager().getSession(innerSessionKey)) != null) {
                        ThreadLocalParam.getInstance().put("INNER_SESSION", session);
                    }
                    ParameterImpl params = new ParameterImpl((HttpServletRequest)request);
                    if (formObject != null) {
                        params.getBean(formObject);
                    }
                    if (action.isValidate() && ((forwardURL = action.validate(validate = new Validate(resultAction, params), resultAction, formObject, params)) != null || validate.isValidate())) {
                        if (forwardURL == null) {
                            forwardURL = validate.getErrorFroward();
                        }
                        if (forwardURL != null) {
                            String errmsg = resultAction.getErrorMessage();
                            if (errmsg == null) {
                                errmsg = DEFAULT_ERROR_MESSAGE;
                            }
                            request.setAttribute("errorActionMessage", (Object)errmsg);
                            record.rollback();
                            this.forward(forwardURL, (HttpServletRequest)request, response);
                            return;
                        }
                    }
                    result = action.execution(resultAction, formObject, params);
                    if (formObject != null) {
                        params.setBean(formObject);
                    }
                    if (resultAction.getState() == 0) {
                        record.commit();
                    } else {
                        record.rollback();
                    }
                }
                finally {
                    try {
                        record.close();
                    }
                    catch (Exception exception) {}
                    ThreadLocalParam.getInstance().clear();
                }
            }
            catch (Exception e) {
                try {
                    record.rollback();
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
            if (result != null) {
                request.setAttribute("actionState", (Object)String.valueOf(resultAction.getState()));
                if (resultAction.getState() != 0) {
                    String errmsg = resultAction.getErrorMessage();
                    if (errmsg == null) {
                        errmsg = DEFAULT_ERROR_MESSAGE;
                    }
                    request.setAttribute("errorActionMessage", (Object)errmsg);
                } else {
                    String message = resultAction.getSuccessMessage();
                    if (message != null) {
                        request.setAttribute("successActionMessage", (Object)message);
                    }
                }
                forwardURL = result;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"## error", (Throwable)e);
            this.errorPage((HttpServletRequest)request, response);
            return;
        }
        catch (Error err) {
            LOG.error((Object)"## error", (Throwable)err);
            this.errorPage((HttpServletRequest)request, response);
            return;
        }
        if (forwardURL == null) return;
        this.forward(forwardURL, (HttpServletRequest)request, response);
    }

    public static final String getMarge(HttpServletRequest request, String name) {
        String server = request.getServletPath();
        int p = server.lastIndexOf("/");
        server = server.substring(0, p + 1);
        return String.valueOf(request.getContextPath()) + FileUtil.convertFullPath(server, name);
    }

    public static final String getServerName(HttpServletRequest request, String name) {
        String server = request.getServletPath();
        int p = server.lastIndexOf("/");
        server = server.substring(0, p + 1);
        return FileUtil.convertFullPath(server, name);
    }

    public static final int getRequestSequenceId(HttpServletRequest request) {
        if (request != null && request instanceof RequestWrapper) {
            return ((RequestWrapper)request).getSequenceId();
        }
        return -1;
    }

    public static final String getBeforeServletPath(HttpServletRequest req) {
        int x;
        String ch;
        String refere = req.getHeader(REFERER);
        if (req == null || refere == null || (refere = refere.trim()).length() <= 0) {
            return null;
        }
        String target = req.getRequestURL().toString();
        int p = target.indexOf(req.getRequestURI());
        if (p == -1) {
            return null;
        }
        target = (target = String.valueOf(target.substring(0, p)) + req.getContextPath()).startsWith("https://") ? target.substring("https://".length()) : target.substring("http://".length());
        String ret = null;
        if (refere.startsWith("https://")) {
            ch = "https://" + target;
            if (refere.startsWith(ch)) {
                ret = refere.substring(ch.length());
            }
        } else if (refere.startsWith("http://") && refere.startsWith(ch = "http://" + target)) {
            ret = refere.substring(ch.length());
        }
        if (ret != null && (x = ret.indexOf("?")) != -1) {
            ret = ret.substring(0, p);
        }
        return ret;
    }

    private void forward(String forward, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestDispatcher disp = request.getRequestDispatcher(forward);
        disp.forward((ServletRequest)request, (ServletResponse)response);
    }

    private final void errorPage(HttpServletRequest req, HttpServletResponse res) {
        try {
            RequestDispatcher disp = req.getRequestDispatcher(this.errorPage);
            disp.forward((ServletRequest)req, (ServletResponse)res);
        }
        catch (Exception e) {
            try {
                res.sendError(404);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final String convertPackageName(boolean mode, String name, String plus) {
        String pkgName = name.substring(0, name.length() - plus.length());
        ArrayList<String> lst = StringUtil.cutString(pkgName, "/");
        int len = lst.size();
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < len - 1) {
            if (i != 0) {
                buf.append(".");
            }
            buf.append(lst.get(i));
            ++i;
        }
        pkgName = lst.get(len - 1);
        if (len != 1) {
            buf.append(".");
        }
        String fd = null;
        fd = mode ? "Action" : "Form";
        buf.append(pkgName.substring(0, 1).toUpperCase()).append(pkgName.substring(1, pkgName.length())).append(fd);
        pkgName = buf.toString();
        buf = null;
        lst = null;
        return StringUtil.changeString(pkgName, "/", ".");
    }

    private static final void setAttributeMap(HttpServletRequest req) throws Exception {
        HashMap<String, Object> params = ConvertHttpParams.getParams(req);
        if (params != null && params.size() > 0) {
            Object[] obj = params.keySet().toArray();
            int len = params.size();
            int i = 0;
            while (i < len) {
                String key = (String)obj[i];
                Object o = params.get(key);
                req.setAttribute(key, o);
                ++i;
            }
        }
    }

    private final String getActionName(HttpServletRequest request) throws Exception {
        String pkgName = ActionServlet.convertPackageName(true, request.getServletPath(), this.plusName);
        return this.actionPackage + pkgName;
    }

    private final String getFormName(HttpServletRequest request) throws Exception {
        String pkgName = ActionServlet.convertPackageName(false, request.getServletPath(), this.plusName);
        return this.formPackage + pkgName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Action getAction(String pkgName) throws Exception {
        Hashtable<String, Action<Object>> mp = null;
        NamingByObjectManager namingByObjectManager = NamingByObjectManager.getInstance();
        synchronized (namingByObjectManager) {
            mp = GlobalInfo.getActionObject();
            if (mp == null) {
                mp = new Hashtable();
                GlobalInfo.setActionObject(mp);
            }
        }
        Action<Object> action = null;
        try {
            Hashtable<String, Action<Object>> hashtable = mp;
            synchronized (hashtable) {
                Object obj = mp.get(pkgName);
                if (obj == null) {
                    obj = Reflect.newObject(pkgName, Thread.currentThread().getContextClassLoader(), new Object[0]);
                    if (obj instanceof Action) {
                        Action ac = (Action)obj;
                        ac.setErrorPageName(this.errorPage);
                        DiContainer container = GlobalInfo.getDiContainer();
                        container.setAction(ac);
                        mp.put(pkgName, ac);
                    } else {
                        throw new IOException("\u6307\u5b9a\u30aa\u30d6\u30b8\u30a7\u30af\u30c8[" + pkgName + "]\u306fAction\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
                    }
                }
                action = obj;
            }
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object getForm(String pkgName) {
        Set<String> mp = null;
        NamingByObjectManager namingByObjectManager = NamingByObjectManager.getInstance();
        synchronized (namingByObjectManager) {
            mp = GlobalInfo.getNotFormObject();
            if (mp == null) {
                mp = Collections.synchronizedSet(new HashSet());
                GlobalInfo.setNotFormObject(mp);
            }
        }
        if (mp.contains(pkgName)) {
            return null;
        }
        Object ret = null;
        try {
            ret = Reflect.newObject(pkgName, Thread.currentThread().getContextClassLoader(), new Object[0]);
        }
        catch (Exception e) {
            mp.add(pkgName);
            ret = null;
        }
        return ret;
    }
}

