/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms.ctbl;

import org.maachang.dao.dbms.ctbl.Table;

class TableUtil {
    TableUtil() {
    }

    public static final String getColumnName(Table table, String type) {
        if (type == null || (type = type.trim()).length() <= 0) {
            return null;
        }
        if ("boolean".equals(type = type.toLowerCase())) {
            return table.typeByBoolean();
        }
        if ("int".equals(type)) {
            return table.typeByInt();
        }
        if ("long".equals(type)) {
            return table.typeByLong();
        }
        if ("float".equals(type)) {
            return table.typeByFloat();
        }
        if ("double".equals(type)) {
            return table.typeByDouble();
        }
        if ("binary".equals(type)) {
            return table.typeByBytes();
        }
        if ("char".equals(type)) {
            return table.typeByChar();
        }
        if ("text".equals(type)) {
            return table.typeByText();
        }
        if ("date".equals(type)) {
            return table.typeByDate();
        }
        if ("time".equals(type)) {
            return table.typeByTime();
        }
        if ("timestamp".equals(type)) {
            return table.typeByTimestamp();
        }
        return null;
    }

    public static final String getColumnType(int[] mode, Table table, String type) {
        if (type == null || (type = type.trim()).length() <= 0) {
            return null;
        }
        String t = type.toLowerCase();
        if ("not_null".equals(t)) {
            mode[0] = 1;
            return table.notNullName();
        }
        if ("not null".equals(t)) {
            mode[0] = 1;
            return table.notNullName();
        }
        if ("unique".equals(t)) {
            mode[0] = 2;
            return table.uniqueName();
        }
        if (t.startsWith("default")) {
            mode[0] = 3;
            String val = type.substring("default".length(), type.length()).trim();
            if (val.startsWith("\"") && val.endsWith("\"")) {
                val = val.substring(1, val.length() - 1);
            } else if (val.startsWith("'") && val.endsWith("'")) {
                val = val.substring(1, val.length() - 1);
            }
            return table.defaultName() + " " + "'" + val + "'";
        }
        return null;
    }

    public static final boolean isIndex(String type) {
        if (type == null || (type = type.trim()).length() <= 0) {
            return false;
        }
        return "index".equals(type = type.toLowerCase());
    }

    public static final boolean isKey(String type) {
        if (type == null || (type = type.trim()).length() <= 0) {
            return false;
        }
        return "key".equals(type = type.toLowerCase());
    }

    public static final boolean isType(String key) {
        if (key == null || (key = key.trim()).length() <= 0) {
            return false;
        }
        return "type".equals(key = key.toLowerCase());
    }
}

