/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.maachang.dao.dbms.RecordFactory;
import org.maachang.dao.dbms.kind.KindManager;
import org.maachang.dao.dbms.kind.SupportKind;
import org.maachang.engine.conf.Config;
import org.maachang.engine.conf.ReadIni;

public class DbmsInfo {
    private static final String DBMS_SECTION = "dbms";

    public static final RecordFactory getRecordFactory(Config conf) throws Exception {
        int maxInt;
        String adapter = conf.get(DBMS_SECTION, "adapter", 0);
        String driver = conf.get(DBMS_SECTION, "driver", 0);
        String url = conf.get(DBMS_SECTION, "url", 0);
        String user = conf.get(DBMS_SECTION, "user", 0);
        String passwd = conf.get(DBMS_SECTION, "passwd", 0);
        String max = conf.get(DBMS_SECTION, "max", 0);
        String autoComit = conf.get(DBMS_SECTION, "autoComit", 0);
        String checkSQL = conf.get(DBMS_SECTION, "checksql", 0);
        try {
            maxInt = Integer.parseInt(max);
        }
        catch (Exception e) {
            maxInt = 15;
        }
        if (maxInt <= 0) {
            maxInt = 15;
        }
        boolean autoComitFlag = false;
        try {
            autoComit = autoComit.trim().toLowerCase();
            autoComitFlag = autoComit.equals("true");
        }
        catch (Exception e) {
            autoComitFlag = false;
        }
        SupportKind kind = KindManager.get(adapter);
        if (kind == null) {
            throw new IllegalArgumentException("\u975e\u30b5\u30dd\u30fc\u30c8\u306e\u30a2\u30c0\u30d7\u30bf\u540d(" + adapter + ")\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        RecordFactory ret = new RecordFactory();
        ret.create(kind, driver, url, user, passwd, maxInt, autoComitFlag, checkSQL);
        return ret;
    }

    public static final Config getConfig(String name) throws Exception {
        return DbmsInfo.getConfig(new FileInputStream(name));
    }

    public static final Config getConfig(InputStream in) throws Exception {
        BufferedReader buf = null;
        try {
            Config ret = new Config();
            buf = new BufferedReader(new InputStreamReader(in, "UTF8"));
            ReadIni.analisys(ret, buf);
            buf.close();
            buf = null;
            Config config = ret;
            return config;
        }
        finally {
            if (buf != null) {
                try {
                    buf.close();
                }
                catch (Exception exception) {}
            }
            buf = null;
        }
    }
}

