/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import org.maachang.dao.dbms.MetaColumn;

public class DbUtil {
    public static final void convertResultByObject(Object out, ResultSet result) throws Exception {
        if (out == null || result == null) {
            return;
        }
        MetaColumn meta = new MetaColumn(out.getClass().getName(), result.getMetaData());
        Class<?> oClass = out.getClass();
        int len = meta.size();
        int i = 0;
        while (i < len) {
            String name = meta.getColumnName(i);
            String javaName = DbUtil.convertDBNameByJavaName(false, name);
            Object value = result.getObject(name);
            if (value != null) {
                String c;
                String mName = "set" + javaName.substring(0, 1).toUpperCase() + javaName.substring(1, javaName.length());
                if (meta.getColumnType(i) == 1 && (c = (String)value).length() == 1) {
                    value = c.equals("0") ? new Boolean(false) : new Boolean(true);
                }
                try {
                    Method md = oClass.getMethod(mName, value.getClass());
                    md.invoke(out, value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    public static final String convertJavaNameByDBName(String name) {
        if (name == null || (name = name.trim()).length() <= 0) {
            return null;
        }
        int len = name.length();
        StringBuilder buf = new StringBuilder();
        buf.append(name.charAt(0));
        int i = 1;
        while (i < len) {
            char c = name.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                buf.append("_");
            }
            buf.append(c);
            ++i;
        }
        String ret = buf.toString().toLowerCase();
        return ret;
    }

    public static final String convertDBNameByJavaName(boolean table, String name) {
        char c;
        if (name == null || (name = name.trim()).length() <= 0) {
            return null;
        }
        name = name.toLowerCase();
        int len = name.length();
        StringBuilder buf = new StringBuilder();
        buf.append(name.charAt(0));
        int i = 1;
        while (i < len) {
            c = name.charAt(i);
            if (c == '_') {
                char cp;
                if (i + 1 < len && (cp = name.charAt(i + 1)) >= 'a' && cp <= 'z') {
                    buf.append((char)(65 + (cp - 97)));
                    ++i;
                }
            } else {
                buf.append(c);
            }
            ++i;
        }
        String ret = buf.toString();
        buf = null;
        if (table && (c = ret.charAt(0)) >= 'a' && c <= 'z') {
            buf = new StringBuilder();
            buf.append((char)(65 + (c - 97))).append(ret.substring(1, ret.length()));
            ret = buf.toString();
        }
        return ret;
    }
}

