/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.engine.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import org.maachang.engine.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    private static final String CHARSET = "UTF8";
    public static final String FILE_SPACE = System.getProperty("file.separator");

    public static String convertFullPath(String ctx, String path) {
        if (ctx == null || (ctx = ctx.trim()).length() <= 0 || path == null || (path = path.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        if (path.startsWith("/") || path.startsWith("\\")) {
            ctx = "/";
        }
        ArrayList<String> ctxList = StringUtil.cutString(ctx, "/\\");
        ArrayList<String> pathList = StringUtil.cutString(path, "/\\");
        if (pathList != null) {
            int len = pathList.size();
            int i = 0;
            while (i < len) {
                String c = pathList.get(i);
                if (!".".equals(c)) {
                    if ("..".equals(c)) {
                        ctxList.remove(ctxList.size() - 1);
                    } else {
                        ctxList.add(c);
                    }
                }
                ++i;
            }
            pathList = null;
        }
        StringBuilder buf = new StringBuilder();
        int len = ctxList.size();
        int i = 0;
        while (i < len) {
            buf.append("/").append(ctxList.get(i));
            ++i;
        }
        return buf.toString();
    }

    public static final String marge(String real, String path) throws Exception {
        if (real == null || (real = real.trim()).length() <= 0 || path == null || (path = path.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        if (real.endsWith("/") || real.endsWith("\\")) {
            real = real.substring(0, real.length() - 1);
        }
        path = path.startsWith("/") || path.startsWith("\\") ? real + path : real + FILE_SPACE + path;
        return FileUtil.getFullPath(path);
    }

    public static final String mkdirs(String dirName) throws IOException {
        File fp = null;
        StringBuffer buf = null;
        String tmp = null;
        String ret = null;
        try {
            if (dirName == null) {
                throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            }
            if (FileUtil.isDirExists(dirName)) {
                fp = new File(dirName);
                tmp = fp.getCanonicalPath();
                buf = new StringBuffer();
                buf.append(tmp);
                buf.append(FILE_SPACE);
                ret = buf.toString();
            } else {
                fp = new File(dirName);
                tmp = fp.getCanonicalPath();
                buf = new StringBuffer();
                buf.append(tmp);
                buf.append(FILE_SPACE);
                ret = buf.toString();
                if (!fp.mkdirs()) {
                    throw new IOException("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea(" + dirName + ")\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                }
            }
        }
        finally {
            fp = null;
            buf = null;
            tmp = null;
        }
        return ret;
    }

    public static final String getFullPath(String path) throws IOException {
        File fp = new File(path);
        return fp.getCanonicalPath();
    }

    public static final String getFileName(String path) {
        int p = path.lastIndexOf("\\");
        int p2 = path.lastIndexOf("/");
        if (p == -1) {
            if (p2 != -1) {
                p = p2;
            }
        } else if (p2 != -1 && p < p2) {
            p = p2;
        }
        if (p == -1) {
            return path;
        }
        return path.substring(p + 1);
    }

    public static final String cutSeparator(boolean mode, String name) {
        if (mode) {
            if ((name = name.trim()).startsWith("/") || name.startsWith("\\")) {
                return name.substring(1);
            }
        } else if ((name = name.trim()).endsWith("/") || name.endsWith("\\")) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }

    public static final void removeFile(String name) {
        try {
            File file = new File(name);
            file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void moveFile(String src, String dest) {
        try {
            File fileSrc = new File(src);
            File fileDest = new File(dest);
            fileSrc.renameTo(fileDest);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final long getLength(String name) {
        long ret = -1L;
        try {
            File file = new File(name);
            ret = file.exists() ? file.length() : -1L;
        }
        catch (Exception e) {
            ret = -1L;
        }
        return ret;
    }

    public static final long getLastTime(String name) {
        long ret = 0L;
        try {
            File file = new File(name);
            ret = file.exists() ? file.lastModified() : 0L;
        }
        catch (Exception e) {
            ret = 0L;
        }
        return ret;
    }

    public static final boolean setLastTime(String name, long lastTime) {
        boolean ret = false;
        try {
            File file = new File(name);
            if (file.exists()) {
                ret = file.setLastModified(lastTime);
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public static final boolean isFileExists(String name) {
        boolean ret;
        if (name == null || name.length() <= 0) {
            return false;
        }
        try {
            File file = new File(name);
            ret = file.exists() ? (!file.isDirectory() ? file.canRead() : false) : false;
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public static final boolean isDirExists(String dirName) {
        File check = null;
        if (dirName == null) {
            return false;
        }
        check = new File(dirName);
        boolean ret = check.isDirectory();
        check = null;
        return ret;
    }

    public static final boolean isRead(String name) {
        boolean ret;
        File file = null;
        if (name == null || name.length() <= 0) {
            return false;
        }
        try {
            try {
                file = new File(name);
                ret = file.canRead();
            }
            catch (Exception e) {
                ret = false;
            }
        }
        finally {
            file = null;
        }
        return ret;
    }

    public static final boolean isWrite(String name) {
        File check = null;
        if (name == null) {
            return false;
        }
        check = new File(name);
        boolean ret = check.canWrite();
        check = null;
        return ret;
    }

    public static final String[] getFileList(String dir) {
        if (dir == null || dir.length() <= 0) {
            return null;
        }
        if (dir.endsWith("/") || dir.endsWith("\\")) {
            dir.substring(0, dir.length() - 1);
        }
        dir = String.valueOf(dir) + FILE_SPACE;
        try {
            int len;
            File fp = new File(dir);
            String[] names = fp.list();
            if (names != null && (len = names.length) > 0) {
                int i = 0;
                while (i < len) {
                    File f = new File(String.valueOf(dir) + names[i]);
                    if (!f.exists() || f.isDirectory()) {
                        names[i] = null;
                    }
                    ++i;
                }
            }
            return names;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final long getDirectoryToLastTime(String name) {
        if (!FileUtil.isDirExists(name)) {
            return -1L;
        }
        return FileUtil.lastUpdateByDirectory(name, -1L);
    }

    public static final void getDirectoryToTargetNextTime(ArrayList<String> out, String name, long targetTime) {
        if (!FileUtil.isDirExists(name)) {
            return;
        }
        FileUtil.targetNextUpdateByDirectory(out, name, targetTime);
    }

    public static final byte[] getFile(String name) throws Exception {
        BufferedInputStream buf = null;
        byte[] ret = null;
        try {
            buf = new BufferedInputStream(new FileInputStream(name));
            long len = FileUtil.getLength(name);
            if (len > Integer.MAX_VALUE) {
                throw new Exception("\u6307\u5b9a\u3055\u308c\u305f\u30d5\u30a1\u30a4\u30eb\u540d(" + name + ")\u306f\u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba\u304c\u5927\u304d\u3044\u305f\u3081\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093");
            }
            ret = new byte[(int)(len & Integer.MAX_VALUE)];
            buf.read(ret);
        }
        finally {
            try {
                buf.close();
            }
            catch (Exception exception) {}
            buf = null;
        }
        return ret;
    }

    public static final String getFileByString(String name) throws Exception {
        return FileUtil.getFileByString(name, CHARSET);
    }

    public static final String getFileByString(String name, String charset) throws Exception {
        char[] tmp = null;
        CharArrayWriter ca = null;
        BufferedReader buf = null;
        String ret = null;
        try {
            int len;
            tmp = new char[8192];
            ca = new CharArrayWriter();
            buf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(name), charset));
            while ((len = buf.read(tmp, 0, 8192)) > 0) {
                ca.write(tmp, 0, len);
            }
            ret = ca.toString();
            ca.close();
            ca = null;
        }
        finally {
            try {
                buf.close();
            }
            catch (Exception exception) {}
            try {
                ca.close();
            }
            catch (Exception exception) {}
            buf = null;
            ca = null;
            tmp = null;
        }
        return ret;
    }

    public static final void setFile(String name, byte[] binary) throws Exception {
        FileUtil.setFile(name, true, binary);
    }

    public static final void setFile(String name, boolean mode, byte[] binary) throws Exception {
        FilterOutputStream buf = null;
        if (name == null || binary == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            buf = mode ? new BufferedOutputStream(new FileOutputStream(name)) : new BufferedOutputStream(new FileOutputStream(name, true));
            buf.write(binary);
        }
        finally {
            try {
                buf.close();
            }
            catch (Exception exception) {}
            buf = null;
        }
    }

    public static final void setFileByString(String name, String value) throws Exception {
        FileUtil.setFileByString(name, true, value, CHARSET);
    }

    public static final void setFileByString(String name, boolean mode, String value) throws Exception {
        FileUtil.setFileByString(name, mode, value, CHARSET);
    }

    public static final void setFileByString(String name, boolean mode, String value, String charset) throws Exception {
        BufferedWriter buf = null;
        if (name == null || value == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            buf = mode ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(name), charset)) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(name, true), charset));
            buf.write(value);
        }
        finally {
            try {
                buf.close();
            }
            catch (Exception exception) {}
            buf = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getScriptByResource(String path, String charset) throws Exception {
        if (charset == null || charset.length() <= 0) {
            charset = CHARSET;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        BufferedReader br = null;
        try {
            StringBuilder buf = new StringBuilder();
            br = new BufferedReader(new InputStreamReader(cl.getResourceAsStream(path), charset));
            while (true) {
                String s;
                if ((s = br.readLine()) == null) {
                    br.close();
                    br = null;
                    String string = buf.toString();
                    return string;
                }
                buf.append(s).append("\r\n");
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static final long lastUpdateByDirectory(String name, long ret) {
        int len;
        if (!name.endsWith("\\") && !name.endsWith("/")) {
            name = String.valueOf(name) + FILE_SPACE;
        }
        File file = new File(name);
        String[] names = file.list();
        file = null;
        if (names != null && (len = names.length) > 0) {
            int i = 0;
            while (i < len) {
                String target = String.valueOf(name) + names[i];
                names[i] = null;
                File fp = new File(target);
                if (fp.isDirectory()) {
                    fp = null;
                    ret = FileUtil.lastUpdateByDirectory(target, ret);
                } else {
                    long now = fp.lastModified();
                    fp = null;
                    if (now > ret) {
                        ret = now;
                    }
                }
                ++i;
            }
        }
        return ret;
    }

    private static final void targetNextUpdateByDirectory(ArrayList<String> lst, String name, long targetTime) {
        int len;
        if (!name.endsWith("\\") && !name.endsWith("/")) {
            name = String.valueOf(name) + FILE_SPACE;
        }
        File file = new File(name);
        String[] names = file.list();
        file = null;
        if (names != null && (len = names.length) > 0) {
            int i = 0;
            while (i < len) {
                String target = String.valueOf(name) + names[i];
                names[i] = null;
                File fp = new File(target);
                if (fp.isDirectory()) {
                    fp = null;
                    FileUtil.targetNextUpdateByDirectory(lst, target, targetTime);
                } else {
                    long now = fp.lastModified();
                    fp = null;
                    if (now > targetTime) {
                        lst.add(new String(target));
                    }
                }
                ++i;
            }
        }
    }
}

