/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.engine.servlet;

import java.util.Hashtable;
import java.util.Set;
import org.maachang.engine.servlet.PageSessionChild;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PageSessionMonitor
extends Thread {
    private static final long MIN_TIMEOUT = 60000L;
    private static final long MAX_TIMEOUT = 43200000L;
    private Hashtable<String, PageSessionChild> manager = null;
    private long time = -1L;
    private volatile boolean stopFlag = true;
    private static final long WAIT = 5000L;

    private PageSessionMonitor() {
    }

    public PageSessionMonitor(long time) {
        if (time <= 60000L) {
            time = 60000L;
        }
        if (time >= 43200000L) {
            time = 43200000L;
        }
        this.manager = new Hashtable();
        this.time = time;
        this.stopFlag = false;
        this.setDaemon(true);
        this.start();
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    protected void clear() {
        this.threadStop();
        this.manager = null;
    }

    protected Hashtable<String, PageSessionChild> getManager() {
        return this.manager;
    }

    protected long getTimeout() {
        return this.time;
    }

    protected synchronized void threadStop() {
        this.stopFlag = true;
    }

    protected synchronized boolean isThreadStop() {
        return this.stopFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            block13: while (true) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception ee) {
                    this.threadStop();
                }
                if (this.isThreadStop()) {
                    return;
                }
                Set<String> keySet = null;
                keySet = this.manager.keySet();
                if (keySet == null) continue;
                Object[] objs = keySet.toArray();
                keySet = null;
                if (objs == null) continue;
                int len = objs.length;
                int i = 0;
                while (true) {
                    if (i >= len) continue block13;
                    if (this.isThreadStop()) continue block13;
                    try {
                        Thread.sleep(30L);
                    }
                    catch (Exception ee) {
                        this.threadStop();
                        continue block13;
                    }
                    try {
                        if (this.manager == null) {
                            this.threadStop();
                            continue block13;
                        }
                        Hashtable<String, PageSessionChild> hashtable = this.manager;
                        synchronized (hashtable) {
                            PageSessionChild ch = this.manager.get((String)objs[i]);
                            if (ch != null && ch.getUpdateTime() + this.time <= System.currentTimeMillis()) {
                                this.manager.remove((String)objs[i]);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
                break;
            }
        }
        catch (Exception keySet) {
            return;
        }
        catch (OutOfMemoryError keySet) {
            return;
        }
        catch (ThreadDeath dt) {
            this.threadStop();
            throw dt;
        }
    }
}

