/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.engine.servlet;

import java.util.Hashtable;
import org.maachang.engine.servlet.DownloadInfo;
import org.maachang.engine.servlet.GlobalInfo;

class DownloadMonitor
extends Thread {
    private volatile boolean stopFlag = false;
    private static DownloadMonitor SNGL = null;
    private static final long TIMEOUT = 30000L;
    private static final long WAIT_TIME = 1000L;

    protected static final void _init() {
        if (SNGL == null) {
            SNGL = new DownloadMonitor();
        }
    }

    protected static final void _destroy() {
        if (SNGL != null) {
            try {
                SNGL.clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
            SNGL = null;
        }
    }

    public static final DownloadMonitor getInstance() {
        return SNGL;
    }

    public DownloadMonitor() {
        this.setDaemon(true);
        this.start();
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    public void clear() {
        this.setStop(true);
    }

    public synchronized boolean isStop() {
        return this.stopFlag;
    }

    private synchronized void setStop(boolean mode) {
        this.stopFlag = mode;
    }

    public void run() {
        block5: while (true) {
            try {
                DownloadMonitor.sleep(1000L);
                if (this.isStop()) {
                    return;
                }
                Hashtable<String, DownloadInfo> man = GlobalInfo.getDownloadKey();
                if (man == null) continue;
                Object[] key = man.keySet().toArray();
                int len = man.size();
                int i = 0;
                while (true) {
                    if (i >= len) continue block5;
                    DownloadInfo info = man.get((String)key[i]);
                    if (info != null && info.getCreateTime() + 30000L <= System.currentTimeMillis()) {
                        man.remove((String)key[i]);
                    }
                    ++i;
                }
            }
            catch (InterruptedException ie) {
                return;
            }
            catch (NullPointerException nullPointerException) {
                continue;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }
}

