/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.engine.servlet;

import java.lang.reflect.Method;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.maachang.engine.servlet.HttpBinary;
import org.maachang.engine.util.Reflect;

public abstract class AbstractParameter {
    private HashMap<String, Long> updateManager = new HashMap();
    private static final String[] DEFAULT_DATE_FORMAT = new String[]{"EEE, d MMM yyyy HH:mm:ss Z", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM/dd-HH:mm:ss", "yyyy/MM/dd-HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd-HH:mm:ss", "yyyy-MM-dd-HH:mm"};
    private static final String[] DEFAULT_DATE_FORMAT_JP = new String[]{"yyyy\u5e74MM\u6708dd\u65e5 HH\u6642mm\u5206ss\u79d2", "yyyy\u5e74MM\u6708dd\u65e5 HH\u6642mm\u5206", "yyyy\u5e74MM\u6708dd\u65e5-HH\u6642mm\u5206ss\u79d2", "yyyy\u5e74MM\u6708dd\u65e5-HH\u6642mm\u5206"};
    private static final String[] DATE_FORMAT = new String[]{"EEE, MMM d, ''yy", "yyyy/MM/dd", "yyyy-MM-dd"};
    private static final String[] DATE_FORMAT_JP = new String[]{"yyyy\u5e74MM\u6708dd\u65e5"};
    private static final String[] TIME_FORMAT = new String[]{"HH:mm:ss", "HH:mm", "h:mm a"};
    private static final String[] TIME_FORMAT_JP = new String[]{"HH\u6642mm\u5206ss\u79d2", "HH\u6642mm\u5206", "h\u6642mm\u5206 a"};

    protected abstract Object getAbstract(String var1);

    protected abstract void setAbstract(String var1, Object var2);

    public Boolean getBoolean(String name) {
        Object o = this.getByPrimitive(name);
        if (o != null) {
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            boolean ret = new Boolean(false);
            try {
                String data = (String)o;
                if (data != null && (data = data.trim()).length() > 0 && ((data = data.toLowerCase()).equals("true") || data.equals("on") || data.equals("ok"))) {
                    ret = new Boolean(true);
                }
            }
            catch (Exception e) {
                ret = new Boolean(false);
            }
            return ret;
        }
        return null;
    }

    public void setBoolean(String name, Boolean value) {
        if (name == null || value == null || (name = name.trim()).length() <= 0) {
            return;
        }
        this.set(name, value.toString());
    }

    public Integer getInteger(String name) {
        Object o = this.getByPrimitive(name);
        if (o != null) {
            if (o instanceof Integer) {
                return (Integer)o;
            }
            Integer ret = null;
            String pm = (String)o;
            try {
                ret = new Integer(pm);
            }
            catch (Exception e) {
                ret = null;
            }
            int p = -1;
            if (ret == null && (p = pm.indexOf(".")) != -1) {
                pm = pm.substring(0, p);
                try {
                    ret = new Integer(pm);
                }
                catch (Exception e) {
                    ret = null;
                }
            }
            return ret;
        }
        return null;
    }

    public void setInteger(String name, Integer value) {
        if (name == null || value == null || (name = name.trim()).length() <= 0) {
            return;
        }
        this.set(name, value.toString());
    }

    public Long getLong(String name) {
        Object o = this.getByPrimitive(name);
        if (o != null) {
            if (o instanceof Long) {
                return (Long)o;
            }
            Long ret = null;
            String pm = (String)o;
            try {
                ret = new Long(pm);
            }
            catch (Exception e) {
                ret = null;
            }
            int p = -1;
            if (ret == null && (p = pm.indexOf(".")) != -1) {
                pm = pm.substring(0, p);
                try {
                    ret = new Long(pm);
                }
                catch (Exception e) {
                    ret = null;
                }
            }
            return ret;
        }
        return null;
    }

    public void setLong(String name, Long value) {
        if (name == null || value == null || (name = name.trim()).length() <= 0) {
            return;
        }
        this.set(name, value.toString());
    }

    public Float getFloat(String name) {
        Object o = this.getByPrimitive(name);
        if (o != null) {
            if (o instanceof Float) {
                return (Float)o;
            }
            Float ret = null;
            try {
                ret = new Float((String)o);
            }
            catch (Exception e) {
                ret = null;
            }
            return ret;
        }
        return null;
    }

    public void setFloat(String name, Float value) {
        if (name == null || value == null || (name = name.trim()).length() <= 0) {
            return;
        }
        this.set(name, value.toString());
    }

    public Double getDouble(String name) {
        Object o = this.getByPrimitive(name);
        if (o != null) {
            if (o instanceof Double) {
                return (Double)o;
            }
            Double ret = null;
            try {
                ret = new Double((String)o);
            }
            catch (Exception e) {
                ret = null;
            }
            return ret;
        }
        return null;
    }

    public void setDouble(String name, Double value) {
        if (name == null || value == null || (name = name.trim()).length() <= 0) {
            return;
        }
        this.set(name, value.toString());
    }

    public String getString(String name) {
        Object o = this.getByPrimitive(name);
        if (o != null) {
            if (!(o instanceof String)) {
                return o.toString();
            }
            return (String)o;
        }
        return null;
    }

    public void setString(String name, String value) {
        if (name == null || value == null || (name = name.trim()).length() <= 0) {
            return;
        }
        this.set(name, value.toString());
    }

    public Date getDate(String format, String name) {
        return this.getDate(format, null, name);
    }

    public void setDate(String name, String format, Date value) {
        this.setDate(name, format, null, value);
    }

    public Date getDate(String format, Locale locale, String name) {
        if (format == null || format.length() <= 0) {
            return null;
        }
        Object o = this.getByPrimitive(name);
        if (o != null) {
            if (o instanceof Date) {
                return (Date)o;
            }
            Date ret = null;
            try {
                if (locale == null) {
                    locale = Locale.US;
                }
                ret = new SimpleDateFormat(format, locale).parse((String)o);
            }
            catch (Exception e) {
                ret = null;
            }
            return ret;
        }
        return null;
    }

    public void setDate(String name, String format, Locale locale, Date value) {
        if (name == null || value == null || format == null || format.length() <= 0 || (name = name.trim()).length() <= 0) {
            return;
        }
        try {
            String val;
            if (locale == null) {
                locale = Locale.US;
            }
            if ((val = new SimpleDateFormat(format, locale).format(value)) != null && val.length() > 0) {
                this.set(name, val);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List getList(String name) {
        return (List)this.getByList(name);
    }

    public void setList(String name, List value) {
        if (name == null || value == null || (name = name.trim()).length() <= 0) {
            return;
        }
        this.set(name, value);
    }

    public HttpBinary getHttpBinary(String name) {
        return (HttpBinary)this.getByHttpBinary(name);
    }

    public Object getObject(String name) {
        return this.get(name);
    }

    public Object getBean(Class cls) throws Exception {
        if (cls == null) {
            return null;
        }
        Object o = Reflect.newObject(cls);
        this.getBean(o);
        return o;
    }

    public void getBean(Object object) throws Exception {
        ArrayList<Method> mds = Reflect.getMethodObjectList(object);
        if (mds != null && mds.size() > 0) {
            int len = mds.size();
            int i = 0;
            while (i < len) {
                Class<?>[] params;
                Method md = mds.get(i);
                String name = md.getName();
                if (name.startsWith("set") && (params = md.getParameterTypes()) != null && params.length == 1) {
                    String key = name.substring("set".length(), name.length());
                    Object val = this.getObject(key = String.valueOf(key.substring(0, 1).toLowerCase()) + key.substring(1, key.length()));
                    if (val != null) {
                        Object cnv;
                        Class<?> paramClass = params[0];
                        if (Reflect.equalsClass(paramClass, val.getClass())) {
                            Reflect.executionMethod(name, object, val);
                        } else if (paramClass.equals(Boolean.class)) {
                            cnv = this.getBoolean(key);
                            if (cnv != null) {
                                Reflect.executionMethod(name, object, cnv);
                            }
                        } else if (paramClass.equals(Integer.class)) {
                            cnv = this.getInteger(key);
                            if (cnv != null) {
                                Reflect.executionMethod(name, object, cnv);
                            }
                        } else if (paramClass.equals(Long.class)) {
                            cnv = this.getLong(key);
                            if (cnv != null) {
                                Reflect.executionMethod(name, object, cnv);
                            }
                        } else if (paramClass.equals(Float.class)) {
                            cnv = this.getFloat(key);
                            if (cnv != null) {
                                Reflect.executionMethod(name, object, cnv);
                            }
                        } else if (paramClass.equals(Double.class)) {
                            cnv = this.getDouble(key);
                            if (cnv != null) {
                                Reflect.executionMethod(name, object, cnv);
                            }
                        } else if (paramClass.equals(Date.class) || paramClass.equals(java.sql.Date.class) || paramClass.equals(Time.class) || paramClass.equals(Timestamp.class)) {
                            cnv = AbstractParameter.convertDateUs(this.getString(key));
                            if (cnv != null) {
                                Reflect.executionMethod(name, object, cnv);
                            }
                        } else if (paramClass.equals(byte[].class)) {
                            cnv = null;
                            if (val instanceof HttpBinary) {
                                cnv = this.getHttpBinary(key).getBinary();
                            } else if (val instanceof byte[]) {
                                cnv = (byte[])this.getObject(key);
                            } else if (val instanceof List && ((List)(cnv = this.getList(key))).size() > 0) {
                                if (((List)cnv).get(0) instanceof HttpBinary) {
                                    cnv = ((HttpBinary)((List)cnv).get(0)).getBinary();
                                } else if (((List)cnv).get(0) instanceof byte[]) {
                                    cnv = (byte[])((List)cnv).get(0);
                                }
                            }
                            if (cnv != null) {
                                Reflect.executionMethod(name, object, cnv);
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    public void setBean(Object object) throws Exception {
        if (object == null) {
            return;
        }
        ArrayList<Method> mds = Reflect.getMethodObjectList(object);
        if (mds != null && mds.size() > 0) {
            int len = mds.size();
            int i = 0;
            while (i < len) {
                Method md = mds.get(i);
                String name = md.getName();
                if ((name.startsWith("get") || name.startsWith("is")) && (md.getParameterTypes() == null || md.getParameterTypes().length <= 0)) {
                    String paramName = null;
                    paramName = name.startsWith("get") ? name.substring("get".length(), name.length()).trim() : name.substring("is".length(), name.length()).trim();
                    if (paramName.length() > 0 && this.updateManager.get(paramName = String.valueOf(paramName.substring(0, 1).toLowerCase()) + paramName.substring(1, paramName.length())) == null) {
                        Object val = null;
                        try {
                            val = Reflect.executionMethod(name, object);
                        }
                        catch (Exception e) {
                            val = null;
                        }
                        if (val != null) {
                            try {
                                this.setAbstract(paramName, val);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    public Object[] getUpdateKeys() {
        return this.updateManager.keySet().toArray();
    }

    private Object get(String name) {
        if (name == null || (name = name.trim()).length() <= 0) {
            return null;
        }
        Object ret = null;
        try {
            ret = this.getAbstract(name);
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    private void set(String name, Object value) {
        if (name == null || (name = name.trim()).length() <= 0 || value == null) {
            return;
        }
        try {
            this.setAbstract(name, value);
            this.updateManager.put(name, new Long(System.currentTimeMillis()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Object getByPrimitive(String name) {
        Object o = this.get(name);
        if (o == null || o instanceof HttpBinary || o instanceof List) {
            if (o instanceof List && ((List)o).size() > 0) {
                return (String)((ArrayList)o).get(0);
            }
            return null;
        }
        return o;
    }

    private Object getByList(String name) {
        Object o = this.get(name);
        if (o != null && o instanceof List) {
            return o;
        }
        return null;
    }

    private Object getByHttpBinary(String name) {
        Object o = this.get(name);
        if (o != null && o instanceof HttpBinary) {
            return o;
        }
        return null;
    }

    private static final Date convertDateUs(String date) {
        if (date == null || (date = date.trim()).length() <= 0) {
            return null;
        }
        Date ret = null;
        ret = AbstractParameter.convertDateByFormatArray(DEFAULT_DATE_FORMAT, Locale.US, date);
        if (ret != null) {
            return ret;
        }
        ret = AbstractParameter.convertDateByFormatArray(DEFAULT_DATE_FORMAT_JP, Locale.JAPAN, date);
        if (ret != null) {
            return ret;
        }
        ret = AbstractParameter.convertDateByFormatArray(DATE_FORMAT, Locale.US, date);
        if (ret != null) {
            return ret;
        }
        ret = AbstractParameter.convertDateByFormatArray(DATE_FORMAT_JP, Locale.JAPAN, date);
        if (ret != null) {
            return ret;
        }
        ret = AbstractParameter.convertDateByFormatArray(TIME_FORMAT, Locale.US, date);
        if (ret != null) {
            return ret;
        }
        ret = AbstractParameter.convertDateByFormatArray(TIME_FORMAT_JP, Locale.JAPAN, date);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    private static final Date convertDateByFormatArray(String[] formats, Locale locale, String date) {
        Date ret = null;
        int len = formats.length;
        int i = 0;
        while (i < len) {
            ret = AbstractParameter.convertDateByFormat(formats[i], locale, date);
            if (ret != null) {
                return ret;
            }
            ++i;
        }
        return null;
    }

    private static final Date convertDateByFormat(String format, Locale locale, String date) {
        try {
            return new SimpleDateFormat(format, locale).parse(date);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

