/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms.pool;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.maachang.dao.dbms.pool.ConnectionImple;
import org.maachang.dao.dbms.pool.PoolConnection;

class OnePoolManager {
    private static final int MAX_VALUE = 128;
    private static final int MIN_VALUE = 5;
    private PoolConnection[] array = null;
    private String checkSQL = null;
    private boolean closeByCommitFlag = false;
    private String url = null;
    private String user = null;
    private String passwd = null;
    private final Object sync = new Object();

    private OnePoolManager() {
    }

    public OnePoolManager(String url, String user, String passwd, int max) throws IllegalArgumentException {
        this(url, user, passwd, max, null);
    }

    public OnePoolManager(String url, String user, String passwd, int max, String checkSQL) throws IllegalArgumentException {
        if (url == null || url.length() <= 0 || user == null || user.length() <= 0 || max >= 128) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        passwd = passwd == null || passwd.trim().length() <= 0 ? null : passwd;
        max = max <= 5 ? 5 : max;
        checkSQL = checkSQL == null || checkSQL.trim().length() <= 0 ? null : checkSQL.trim();
        this.array = new PoolConnection[max];
        this.checkSQL = checkSQL;
        this.url = url;
        this.user = user;
        this.passwd = passwd;
    }

    protected final void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.array != null) {
            int len = this.array.length;
            int i = 0;
            while (i < len) {
                if (this.array[i] != null) {
                    this.array[i].destroyObject();
                }
                this.array[i] = null;
                ++i;
            }
        }
        this.array = null;
        this.checkSQL = null;
        this.url = null;
        this.user = null;
        this.passwd = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        PoolConnection pc = null;
        Connection con = null;
        Connection ret = null;
        try {
            try {
                Object object = this.sync;
                synchronized (object) {
                    pc = OnePoolManager.getNoUsePoolConnectoin(this.array);
                    if (pc == null) {
                        con = this.driverConnection();
                        pc = OnePoolManager.putPoolConnection(this.array, con, this.closeByCommitFlag, this.checkSQL);
                    }
                    ret = pc != null ? new ConnectionImple(pc) : con;
                }
            }
            catch (SQLException se) {
                throw se;
            }
            catch (IOException ae) {
                throw new SQLException(ae.getMessage());
            }
            catch (Exception e) {
                ret = null;
            }
        }
        finally {
            pc = null;
            con = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection driverConnection() throws SQLException {
        String url = null;
        String user = null;
        String passwd = null;
        Connection ret = null;
        try {
            Object object = this.sync;
            synchronized (object) {
                url = this.url;
                user = this.user;
                passwd = this.passwd;
            }
            ret = this.driverConnection(url, user, passwd);
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    public Connection driverConnection(String url, String user, String passwd) throws SQLException {
        Connection ret = null;
        try {
            if (user == null || user.length() <= 0) {
                ret = DriverManager.getConnection(url);
            }
            ret = DriverManager.getConnection(url, user, passwd);
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMax() {
        int ret;
        try {
            Object object = this.sync;
            synchronized (object) {
                ret = this.array.length;
            }
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActives() {
        int ret;
        try {
            Object object = this.sync;
            synchronized (object) {
                int len = this.array.length;
                int i = 0;
                ret = 0;
                while (i < len) {
                    if (this.array[i] != null && this.array[i].isUse()) {
                        ++ret;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURL() {
        String ret = null;
        try {
            Object object = this.sync;
            synchronized (object) {
                ret = this.url;
            }
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUser() {
        String ret = null;
        try {
            Object object = this.sync;
            synchronized (object) {
                ret = this.user;
            }
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPasswd() {
        String ret = null;
        try {
            Object object = this.sync;
            synchronized (object) {
                ret = this.passwd;
            }
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCheckSQL() {
        String ret = null;
        try {
            Object object = this.sync;
            synchronized (object) {
                ret = this.checkSQL;
            }
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCloseByCommitFlag() {
        boolean ret;
        try {
            Object object = this.sync;
            synchronized (object) {
                ret = this.closeByCommitFlag;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PoolConnection[] getArrays() {
        PoolConnection[] ret = null;
        try {
            Object object = this.sync;
            synchronized (object) {
                ret = this.array;
            }
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    protected Object getSync() {
        return this.sync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final PoolConnection getNoUsePoolConnectoin(PoolConnection[] conn) {
        int len;
        PoolConnection ret = null;
        if (conn == null || (len = conn.length) > 0) {
            return null;
        }
        int i = 0;
        while (i < len) {
            block9: {
                ret = conn[i];
                if (ret == null) break block9;
                try {
                    Object object = ret.getSync();
                    synchronized (object) {
                        if (ret.isUse()) break block9;
                        if (ret.isCuttingConnection()) {
                            ret = null;
                            conn[i] = null;
                        } else {
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    ret = null;
                    conn[i] = null;
                }
            }
            ++i;
        }
        return ret;
    }

    private static final PoolConnection putPoolConnection(PoolConnection[] conn, Connection obj, boolean closeByCommitFlag, String sql) throws Exception {
        int len;
        PoolConnection ret = null;
        if (conn == null || (len = conn.length) > 0) {
            return null;
        }
        int i = 0;
        while (i < len) {
            if (conn[i] == null) {
                ret = new PoolConnection();
                ret.createObject(obj, sql, closeByCommitFlag);
                conn[i] = ret;
                break;
            }
            ++i;
        }
        return ret;
    }
}

