/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms.ctbl;

import java.util.HashSet;
import org.maachang.dao.dbms.ctbl.Table;
import org.maachang.dao.dbms.ctbl.TableUtil;
import org.maachang.engine.conf.Config;
import org.maachang.engine.util.StringUtil;

public class TableH2
implements Table {
    public String getAdapter() {
        return "h2";
    }

    public String createTable(Config params) {
        StringBuilder buf = new StringBuilder();
        Object[] sections = params.getSections();
        if (sections != null && sections.length > 0) {
            int len = sections.length;
            int i = 0;
            while (i < len) {
                if (sections[i] != null) {
                    this.createOneSection(buf, (String)sections[i], params);
                }
                ++i;
            }
            return buf.toString();
        }
        return null;
    }

    public String typeByBoolean() {
        return "BOOL";
    }

    public String typeByInt() {
        return "INTEGER";
    }

    public String typeByLong() {
        return "BIGINT";
    }

    public String typeByFloat() {
        return "REAL";
    }

    public String typeByDouble() {
        return "DOUBLE";
    }

    public String typeByBytes() {
        return "BYTEA";
    }

    public String typeByChar() {
        return "VARCHAR(255)";
    }

    public String typeByText() {
        return "VARCHAR_IGNORECASE";
    }

    public String typeByDate() {
        return "DATE";
    }

    public String typeByTime() {
        return "TIME";
    }

    public String typeByTimestamp() {
        return "TIMESTAMP";
    }

    public String primaryKeyName() {
        return "CONSTRAINT [KEY_NAME] PRIMARY KEY";
    }

    public String indexName() {
        return null;
    }

    public String notNullName() {
        return "NOT NULL";
    }

    public String uniqueName() {
        return "UNIQUE";
    }

    public String defaultName() {
        return "DEFAULT";
    }

    private void createOneSection(StringBuilder buf, String section, Config params) {
        block20: {
            if (section == null) {
                return;
            }
            String[] keys = params.getKeys(section);
            if (keys == null || keys.length <= 0) break block20;
            int len = keys.length;
            HashSet<String> primaryKey = new HashSet<String>();
            buf.append("drop table ").append(section).append("; \n");
            buf.append("create table ").append(section).append("(");
            buf.append("id BIGINT NOT NULL UNIQUE");
            boolean next = true;
            int i = 0;
            while (i < len) {
                block21: {
                    if (next) {
                        buf.append(",");
                        next = false;
                    }
                    String key = keys[i];
                    String type = null;
                    String not_null = null;
                    String unique = null;
                    String def = null;
                    String[] one = params.getAll(section, key);
                    int lenJ = one.length;
                    int[] mode = new int[1];
                    if ("id".equals(key.toLowerCase()) || TableUtil.isType(key)) break block21;
                    int j = 0;
                    while (j < lenJ) {
                        block23: {
                            block24: {
                                String tmp;
                                block22: {
                                    tmp = null;
                                    tmp = TableUtil.getColumnName(this, one[j]);
                                    if (tmp == null) break block22;
                                    type = tmp;
                                    break block23;
                                }
                                tmp = TableUtil.getColumnType(mode, this, one[j]);
                                if (tmp == null) break block24;
                                switch (mode[0]) {
                                    case 1: {
                                        not_null = tmp;
                                        break;
                                    }
                                    case 2: {
                                        if (this.typeByInt().equals(type) || this.typeByLong().equals(type) || this.typeByFloat().equals(type) || this.typeByDouble().equals(type) || this.typeByDate().equals(type) || this.typeByTime().equals(type) || this.typeByTimestamp().equals(type)) {
                                            unique = tmp;
                                            break;
                                        }
                                        break block23;
                                    }
                                    case 3: {
                                        if (this.typeByBytes().equals(type)) break;
                                        def = tmp;
                                    }
                                }
                                break block23;
                            }
                            if (TableUtil.isIndex(one[j])) {
                                primaryKey.add(key.toLowerCase());
                                not_null = this.notNullName();
                            }
                            if (TableUtil.isKey(one[j])) {
                                primaryKey.add(key.toLowerCase());
                                not_null = this.notNullName();
                            }
                        }
                        ++j;
                    }
                    if (type != null) {
                        buf.append(key.toLowerCase()).append(" ").append(type);
                        if (unique != null) {
                            buf.append(" ").append(unique);
                        }
                        if (not_null != null) {
                            buf.append(" ").append(not_null);
                        }
                        if (def != null) {
                            buf.append(" ").append(def);
                        }
                        next = true;
                    }
                }
                ++i;
            }
            if (!buf.toString().endsWith(",")) {
                buf.append(",");
            }
            if (primaryKey.size() > 0) {
                buf.append(StringUtil.changeString(this.primaryKeyName(), "[KEY_NAME]", String.valueOf(section.toLowerCase()) + "_pk")).append("(");
                buf.append("id");
                Object[] vals = primaryKey.toArray();
                int lenI = vals.length;
                int i2 = 0;
                while (i2 < lenI) {
                    buf.append(",").append(vals[i2]);
                    ++i2;
                }
                buf.append(")");
            } else {
                buf.append(StringUtil.changeString(this.primaryKeyName(), "[KEY_NAME]", String.valueOf(section.toLowerCase()) + "_pk"));
                buf.append("(id)");
            }
            buf.append(") ; \n");
            buf.append("drop sequence ").append(section.toLowerCase()).append("_id_seq").append("; \n");
            buf.append("create sequence ").append(section.toLowerCase()).append("_id_seq").append("; \n");
        }
    }

    public Object getBooleanType(Boolean src) {
        return src;
    }

    public Object getBooleanByTrue() {
        return null;
    }

    public Object getBooleanByFalse() {
        return null;
    }
}

