/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms;

import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.maachang.dao.dbms.DbUtil;
import org.maachang.dao.dbms.MetaColumn;
import org.maachang.dao.dbms.Record;
import org.maachang.dao.dbms.ResultUtil;
import org.maachang.dao.dbms.kind.SupportKind;
import org.maachang.engine.util.Reflect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionDao {
    private static final String RESULT_BY_SQL = "select";
    private static final String INSERT_BY_SQL = "insert";
    public static final String SEQ_COLUMN = "id";
    public static final String CREATE_TIME = "create_time";
    public static final String UPDATE_TIME = "update_time";

    public static final int execution(ArrayList out, Long[] outId, Record record, Class type, String model, MetaColumn meta, String sql, int offset, int limit, ArrayList<Object> params) throws Exception {
        Object[] o = null;
        if (params != null && params.size() > 0) {
            int len = params.size();
            o = new Object[len];
            int i = 0;
            while (i < len) {
                o[i] = params.get(i);
                ++i;
            }
        }
        return ExecutionDao.execution(out, outId, record, type, model, meta, sql, offset, limit, o);
    }

    public static final int execution(ArrayList out, Long[] outId, Record record, Class type, String model, MetaColumn meta, String sql, int offset, int limit, Object[] params) throws Exception {
        String s;
        String s2;
        if (record == null) {
            return 0;
        }
        if (sql == null || (sql = sql.trim()).length() <= 0) {
            throw new IllegalArgumentException("SQL\u6587\u306f\u4e0d\u6b63\u3067\u3059");
        }
        SupportKind kind = record.getSupportKind();
        if (kind == null) {
            throw new IOException("\u30b5\u30dd\u30fc\u30c8\u5916\u306e\u30a2\u30c0\u30d7\u30bf\u3067\u3059");
        }
        String lower = sql.toLowerCase();
        boolean selectFlag = lower.startsWith(RESULT_BY_SQL);
        boolean insertFlag = lower.startsWith(INSERT_BY_SQL);
        if (selectFlag) {
            ResultSet rs = null;
            try {
                rs = params == null || params.length <= 0 ? record.executeQuery(sql) : record.executeQuery(sql, params);
                if (lower.startsWith("select count(*)")) {
                    int count = 0;
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                    rs.close();
                    rs = null;
                    int n = count;
                    return n;
                }
                out.clear();
                if (limit <= 0) {
                    limit = Integer.MAX_VALUE;
                }
                if (offset <= 0) {
                    offset = 0;
                }
                ExecutionDao.pushResult(out, type, rs, offset, limit);
                rs.close();
                rs = null;
                int n = out.size();
                return n;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
                rs = null;
            }
        }
        boolean seqFlag = ExecutionDao.isSequence(meta);
        Long seq = null;
        if (outId != null && outId.length >= 1 && seqFlag && insertFlag && (s2 = kind.getSequenceId(model)) != null && (seq = ExecutionDao.getSequenceId(record, s2)) != null) {
            params[0] = seq;
        }
        int ret = 0;
        ret = params == null || params.length <= 0 ? record.executeUpdate(sql) : record.executeUpdate(sql, params);
        if (outId != null && outId.length >= 1 && seqFlag && insertFlag && seq != null && (s = kind.getInsertIdBySQL()) != null) {
            seq = ExecutionDao.getInsertId(record, s);
        }
        if (outId != null) {
            outId[0] = seq;
        }
        return ret;
    }

    public static final boolean isSequence(MetaColumn meta) throws Exception {
        int len = meta.size();
        int i = 0;
        while (i < len) {
            if (SEQ_COLUMN.equals(meta.getColumnName(i).toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean isCreateTime(MetaColumn meta) throws Exception {
        int len = meta.size();
        int i = 0;
        while (i < len) {
            if (CREATE_TIME.equals(meta.getColumnName(i).toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean isUpdateTime(MetaColumn meta) throws Exception {
        int len = meta.size();
        int i = 0;
        while (i < len) {
            if (UPDATE_TIME.equals(meta.getColumnName(i).toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final Long getSequenceId(Record record, String sql) throws Exception {
        ResultSet result = null;
        result = record.executeQuery(sql);
        if (result != null) {
            Long ret;
            result.next();
            Long l = ret = Long.valueOf(result.getLong(1));
            return l;
        }
        Long l = null;
        return l;
        {
            finally {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private static final Long getInsertId(Record record, String sql) throws Exception {
        ResultSet result = null;
        result = record.executeQuery(sql);
        if (result != null) {
            Long ret;
            result.next();
            Long l = ret = Long.valueOf(result.getLong(1));
            return l;
        }
        Long l = null;
        return l;
        {
            finally {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private static final void pushResult(ArrayList out, Class type, ResultSet result, int offset, int limit) throws Exception {
        ResultUtil.setPosition(result, offset);
        int i = 0;
        while (i < limit) {
            if (!result.next()) break;
            Object o = Reflect.newObject(type);
            DbUtil.convertResultByObject(o, result);
            out.add(o);
            ++i;
        }
    }
}

