/*
 * @(#)JRcSpringService.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.spring ;

import org.springframework.context.ApplicationContext;

import com.JRcServer.JRCommand;
import com.JRcServer.JRcService;
import com.JRcServer.server.JRcManagerFactory;

/**
 * JRcServerSpringバージョン用サービス処理.
 *  
 * @version 2006/09/10
 * @author  masahito suzuki
 * @since   JRcServer-Spring 1.00
 */
public class JRcSpringService implements JRcService {
    
    /**
     * サーババージョン名.
     */
    public static final String VERSION = "JRcSpring-1.00" ;
    
    /**
     * コンストラクタ.
     */
    public JRcSpringService() {
        
    }
    
    /**
     * このサービスを管理するサーババージョンを取得.
     * <BR><BR>
     * このサービスを管理するサーババージョンを取得します.
     * <BR>
     * @return String サービスサーババージョンが返されます.
     */
    public synchronized String getServerVersion() {
        
        return new StringBuffer().
            append( VERSION ).
            append( "/" ).
            append( JRcManagerFactory.getVersion() ).
            toString() ;
            
    }
    
    /**
     * 対象サービスから、JRCommandを取得.
     * <BR><BR>
     * 対象サービスから、JRCommandを取得します.
     * <BR>
     * @param name 対象のサービス名を設定します.
     * @return JRCommand 対象のコマンド情報が返されます.
     */
    public synchronized JRCommand getService( String name ) {
        
        JRcSpringOption opt = null ;
        ApplicationContext context = null ;
        Object bean = null ;
        JRCommand ret = null ;
        
        if( name == null || ( name = name.trim() ).length() <= 0 ) {
            return null ;
        }
        
        opt = ( JRcSpringOption )JRcManagerFactory.
            getJRcBaseManager().getOption() ;
        context = opt.getAppeicationContext() ;
        
        bean = context.getBean( name ) ;
        if( bean == null || ( bean instanceof JRCommand ) == false ) {
            ret = null ;
        }
        else {
            ret = ( JRCommand )bean ;
        }
        
        return ret ;
        
    }
    
    /**
     * 有効サービス名一覧を取得.
     * <BR><BR>
     * 有効サービス名一覧を取得します.
     * <BR>
     * @return String[] 有効サービス名一覧が返されます.
     */
    public synchronized String[] getServiceNames() {
        
        JRcSpringOption opt = null ;
        opt = ( JRcSpringOption )JRcManagerFactory.
            getJRcBaseManager().getOption() ;
        
        return opt.getServiceNames() ;
        
    }
    
    /**
     * 有効サービス数を取得.
     * <BR><BR>
     * 有効となるサービス数を取得します.
     * <BR>
     * @return int 有効サービス数が返されます.
     */
    public synchronized int getServerSize() {
        
        JRcSpringOption opt = null ;
        opt = ( JRcSpringOption )JRcManagerFactory.
            getJRcBaseManager().getOption() ;
        
        return opt.getServerSize() ;
        
    }
    
    /**
     * サービス名が存在するかチェック.
     * <BR><BR>
     * サービス名が存在するかチェックします.
     * <BR>
     * @param name チェック対象のサービス名を設定します.
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]を設定した場合、存在します.<BR>
     *                 [false]を設定した場合、存在しません.
     */
    public synchronized boolean isService( String name ) {
        
        return ( this.getService( name ) == null ) ? false : true ;
        
    }
    
}

