/*
 * @(#)JRcSpringOption.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.spring ;

import org.springframework.context.ApplicationContext;

import com.JRcServer.server.control.JRcRemoteControlServer;

/**
 * JRcServerSpringバージョン用オプション.
 *  
 * @version 2006/09/08
 * @author  masahito suzuki
 * @since   JRcServer-Spring 1.00
 */
public class JRcSpringOption {
    
    /**
     * Spring用アプリケーションコンテキスト.
     */
    private ApplicationContext appeicationContext = null ;
    
    /**
     * シャットダウンコマンド待ちオブジェクト.
     */
    private JRcRemoteControlServer control = null ;
    
    /**
     * JRcServer対応サービス名.
     */
    private String[] serviceNames = null ;
    
    
    
    /**
     * コンストラクタ.
     */
    public JRcSpringOption() {
        
    }
    
    /**
     * appeicationContext を取得.
     * <BR><BR>
     * @return appeicationContext が返されます.
     */
    public ApplicationContext getAppeicationContext() {
        return appeicationContext;
    }
    
    /**
     * appeicationContext を設定.
     * <BR><BR>
     * @param appeicationContext appeicationContext を設定します.
     */
    public void setAppeicationContext(ApplicationContext appeicationContext) {
        this.appeicationContext = appeicationContext;
    }
    
    /**
     * serviceNames を取得.
     * <BR><BR>
     * @return serviceNames が返されます.
     */
    public String[] getServiceNames() {
        return serviceNames;
    }
    
    /**
     * serviceNames を設定.
     * <BR><BR>
     * @param serviceNames serviceNames を設定します.
     */
    public void setServiceNames(String[] serviceNames) {
        this.serviceNames = serviceNames;
    }
    
    /**
     * serverSize を取得.
     * <BR><BR>
     * @return serverSize が返されます.
     */
    public int getServerSize() {
        return ( this.serviceNames == null ) ?
            0 : this.serviceNames.length ;
    }
    
    /**
     * control を取得.
     * <BR><BR>
     * @return control が返されます.
     */
    public JRcRemoteControlServer getControl() {
        return control;
    }
    
    /**
     * control を設定.
     * <BR><BR>
     * @param control control を設定します.
     */
    public void setControl(JRcRemoteControlServer control) {
        this.control = control;
    }
    
}

