/*
 * @(#)JRcSpringService.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.spring ;

import com.JRcServer.server.JRcServerConf;

/**
 * JRcServerSpringバージョンコンフィグ.
 *
 * @version 2006/09/13
 * @author  Masahito Suzuki
 * @since   JRcServer-Spring 1.00
 */
public class JRcSpringConf extends JRcServerConf {
    
    /**
     * コンフィグセクション : Springコンフィグファイル.
     */
    private static final String SECTION_SPRING_BEAN_CONFIG = "spring-config" ;
    
    /**
     * Springコンフィグファイル : SpringBeanファイル.
     */
    private static final String SPEING_BEAN_FILE = "bean-file" ;
    
    
    
    /**
     * コンストラクタ.
     */
    public JRcSpringConf() {
        super() ;
    }
    
    /**
     * ファイナライズ処理定義.
     * <BR><BR>
     * ファイナライズ処理定義.
     * @exception Exception 例外処理が返されます.
     */
    protected void finalize() throws Exception {
        
        try{
            this.clear() ;
        }catch( Exception t ){
        }
        
    }
    
    /**
     * SpringBeanファイル設定数を取得.
     * <BR><BR>
     * SpringBeanファイル設定数を取得します.<BR>
     * この情報はセクション名[spring-config]で設定されている、
     * 登録名[bean-file]の情報数が返されます.
     * <BR>
     * @return int 定義数が返されます.
     */
    public int getBeanFileLength() {
        
        return this.getLength(
            JRcSpringConf.SECTION_SPRING_BEAN_CONFIG,
            JRcSpringConf.SPEING_BEAN_FILE
        ) ;
    }
    
    /**
     * SpringBeanファイルの登録名を取得.
     * <BR><BR>
     * SpringBeanファイルの登録名を取得します.<BR>
     * この情報はセクション名[spring-config]以下に
     * 設定されている[bean-file]情報を取得します.
     * <BR>
     * @param no 対象の項番を設定します.
     * @return String SpringBeanファイルの登録名が返されます.<BR>
     *                情報が存在しない場合[null]が返されます.
     */
    public String getBeanFile( int no ) {
        
        String ret = null ;
        
        try{
            
            ret = this.getString(
                JRcSpringConf.SECTION_SPRING_BEAN_CONFIG,
                JRcSpringConf.SPEING_BEAN_FILE,
                no
            ) ;
            
        }catch( Exception t ){
            ret = null ;
        }
        
        return ret ;
    }
    
    /**
     * 定義ファイルで必要なセクション名群が有効であるかチェック.
     * <BR><BR>
     * 定義ファイルで必要なセクション名群が有効であるかチェックします.
     * <BR>
     * @return boolean 有効であるかチェックします.<BR>
     *                 [true]が返された場合、有効です.<BR>
     *                 [false]が返された場合、有効ではありません.
     */
    public boolean isUseSection()
    {
        return (
            super.isUseSection() == false ||
            this.isSection( JRcSpringConf.SECTION_SPRING_BEAN_CONFIG ) == false
        ) ? false : true ;
    }
    
}
