/*
 * @(#)JRcHello.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.spring ;

import java.io.PrintWriter;

import com.JRcServer.JRCommand;
import com.JRcServer.JRCommandException;
import com.JRcServer.JRcRequest;
import com.JRcServer.JRcResponse;
import com.JRcServer.JRcSession;

/**
 * JRcServerSpringセッションサンプル.
 *  
 * @version 2006/09/17
 * @author  masahito suzuki
 * @since   JRcServer-Spring 1.00
 */
public class JRcHello implements JRCommand {
    
    /**
     * コンストラクタ.
     */
    public JRcHello() {
        
    }
    
    /**
     * コマンド.
     * <BR><BR>
     * コマンド実行された場合に呼び出されるメソッド.
     * <BR>
     * @param request リクエスト情報が設定されます.
     * @param response レスポンス情報が設定されます.
     * @exception JRCommandException コマンド実行例外.
     */
    public void execution( JRcRequest request,JRcResponse response )
        throws JRCommandException {
        
        String s = null ;
        String v = null ;
        PrintWriter w = null ;
        JRcSession session = null ;
        
        try {
            
            w = response.getWriter() ;
            
            if( request.isParameterName( "string" ) == false ) {
                
                throw new JRCommandException(
                    "引数[string]が存在しません." ) ;
                    
            }
            
            s = request.getParameterToString( "string" ) ;
            session = request.getSession() ;
            
            if( ( v = ( String )session.getValue( "string" ) ) == null ) {
                w.println( "セッションに[string:" + s + "]を登録しました" ) ;
            }
            else {
                w.println( "前回登録内容[string:" + v + "]" ) ;
            }
            
            session.putValue( "string",s ) ;
            
        } catch( JRCommandException je ) {
            throw je ;
        } catch( Exception e ) {
            throw new JRCommandException( e ) ;
        }
        
    }
    
    /**
     * コマンドヘルプ情報取得.
     * <BR><BR>
     * コマンドヘルプ情報を取得します.
     * <BR>
     * @param writer コマンドヘルプ情報が返されます.
     */
    public void getHelp( PrintWriter writer ) {
        writer.println( "JRcSpringBean-サンプル." ) ;
        writer.println( " " ) ;
        writer.println( "  string : 文字情報を設定します." ) ;
        writer.println( "  戻り値 : 前回対象クライアントが入力した内容が返されます." ) ;
    }
    
}

