/*
 * @(#)JRcStateDef.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer ;

/**
 * JRcServerステータス定義.
 *  
 * @version 2006/09/02
 * @author  masahito suzuki
 * @since   JRcServerBase 1.00
 */
public class JRcStateDef
{
    
    /**
     * ステータス : 警告MASK値.
     */
    public static final int STATE_MASK_WARNING = 0x10000000 ;
    
    /**
     * ステータス : エラーMASK値.
     */
    public static final int STATE_MASK_ERROR = 0x20000000 ;
    
    /**
     * ステータス : 正常.
     */
    public static final int STATE_SUCCESS = 0x00000000 ;
    
    /**
     * ステータス : 停止.
     */
    public static final int STATE_DOWN = 0x20000001 ;
    
    /**
     * ステータス : 起動中.
     */
    public static final int STATE_STARTUP = 0x20000002 ;
    
    /**
     * ステータス : 停止中.
     */
    public static final int STATE_SHUTDOWN = 0x20000003 ;
    
    /**
     * ステータス : 異常.
     */
    public static final int STATE_ERROR = 0x20000004 ;
    
    /**
     * ステータス : カスタム正常ステータス.
     */
    public static final int STATE_CUSTOM_SUCCESS = 0x00000001 ;
    
    /**
     * ステータス : カスタム警告ステータス.
     */
    public static final int STATE_CUSTOM_WARNING = 0x10000001 ;
    
    /**
     * ステータス : カスタム異常ステータス.
     */
    public static final int STATE_CUSTOM_ERROR = 0x20000005 ;
    
    /**
     * コンストラクタ.
     */
    private JRcStateDef() {
        
    }
}

