/*
 * @(#)JRcResponseBean.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer ;

import com.JRcServer.commons.def.BaseDef;
import com.JRcServer.commons.resource.BinResource;

/**
 * JRcServerレスポンスBean.
 *  
 * @version 2006/09/06
 * @author  masahito suzuki
 * @since   JRcServerAPI 1.00
 */
public class JRcResponseBean {

    /**
     * デフォルトキャラクタセット.
     */
    public static final String DEFAULT_CHARSET = BaseDef.UTF8 ;
    
    /**
     * デフォルトMimeタイプ.
     */
    public static final String DEFAULT_MIME_TYPE = "text/plain" ;
    
    /**
     * セッションID.
     */
    private long sessionID = -1L ;
    
    /**
     * 戻り値.
     */
    private int result = -1 ;
    
    /**
     * 戻り値メッセージ.
     */
    private String resultMessage = null ;
    
    /**
     * データモード.
     */
    private boolean mode = false ;
    
    /**
     * 変換キャラクタセット.
     */
    private String charset = DEFAULT_CHARSET ;
    
    /**
     * Mimeタイプ.
     */
    private String mimeType = DEFAULT_MIME_TYPE ;
    
    /**
     * バイナリリソース.
     */
    private BinResource binary = null ;
    
    /**
     * モードロック.
     */
    private boolean lock = false ;
    
    
    
    /**
     * コンストラクタ.
     */
    public JRcResponseBean() {
        
    }
    
    /**
     * ファイナライズ処理定義.
     * <BR><BR>
     * ファイナライズ処理定義.
     * @exception Exception 例外処理が返されます.
     */
    protected final void finalize() throws Exception
    {
        
        try{
            this.destroy() ;
        }catch( Exception t ){
        }
        
    }
    
    /**
     * オブジェクト破棄.
     * <BR><BR>
     * オブジェクトを破棄します.
     */
    public void destroy() {
        sessionID = -1L ;
        result = -1 ;
        resultMessage = null ;
        mode = false ;
        charset = DEFAULT_CHARSET ;
        mimeType = DEFAULT_MIME_TYPE ;
        binary = null ;
        lock = false ;
    }
    
    /**
     * binary を取得.
     * <BR><BR>
     * @return binary が返されます.
     */
    public BinResource getBinary() {
        return binary;
    }
    
    /**
     * binary を設定.
     * <BR><BR>
     * @param binary binary を設定します.
     */
    public void setBinary(BinResource binary) {
        if( this.lock == false ) {
            this.binary = binary;
        }
    }
    
    /**
     * mode を取得.
     * <BR><BR>
     * @return mode が返されます.
     */
    public boolean isMode() {
        return mode;
    }
    
    /**
     * mode を設定.
     * <BR><BR>
     * @param mode mode を設定します.
     */
    public void setMode(boolean mode) {
        if( this.lock == false ) {
            this.mode = mode;
        }
    }
    
    /**
     * charset を取得.
     * <BR><BR>
     * @return charset が返されます.
     */
    public String getCharset() {
        return charset;
    }
    
    /**
     * charset を設定.
     * <BR><BR>
     * @param charset charset を設定します.
     */
    public void setCharset(String charset) {
        if( this.lock == false ) {
            this.charset = charset;
        }
    }
    
    /**
     * mimeType を取得.
     * <BR><BR>
     * @return mimeType が返されます.
     */
    public String getMimeType() {
        return mimeType;
    }
    
    /**
     * mimeType を設定.
     * <BR><BR>
     * @param mimeType mimeType を設定します.
     */
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }
    
    /**
     * result を取得.
     * <BR><BR>
     * @return result が返されます.
     */
    public int getResult() {
        return result;
    }
    
    /**
     * result を設定.
     * <BR><BR>
     * @param result result を設定します.
     */
    public void setResult(int result) {
        this.result = result;
    }
    
    /**
     * resultMessage を取得.
     * <BR><BR>
     * @return resultMessage が返されます.
     */
    public String getResultMessage() {
        return resultMessage;
    }

    /**
     * resultMessage を設定.
     * <BR><BR>
     * @param resultMessage resultMessage を設定します.
     */
    public void setResultMessage(String resultMessage) {
        this.resultMessage = resultMessage;
    }

    /**
     * sessionID を取得.
     * <BR><BR>
     * @return sessionID が返されます.
     */
    public long getSessionID() {
        return sessionID;
    }
    
    /**
     * sessionID を設定.
     * <BR><BR>
     * @param sessionID sessionID を設定します.
     */
    public void setSessionID(long sessionID) {
        this.sessionID = sessionID;
    }
    
    /**
     * オブジェクトが有効であるかチェック.
     * <BR><BR>
     * @return boolean オブジェクトが有効である場合は[true].
     */
    public boolean isBean() {
        return (
            this.binary == null ||
            this.charset == null ||
            this.charset.length() <= 0
        ) ? false : true ;
    }
    
    /**
     * ロック処理.
     * <BR><BR>
     * このBeanをロックします.
     */
    public void lock() {
        this.lock = true ;
    }
    
    /**
     * アンロック.
     * <BR><BR>
     * ロックされた内容を解除します.
     */
    public void unlock() {
        this.lock = false ;
    }
    
    /**
     * ロック状態を取得.
     * <BR><BR>
     * ロック状態を取得します.
     * <BR>
     * @return boolean ロック状態が返されます.<BR>
     *                 [true]の場合、ロックされています.<BR>
     *                 [false]の場合、アンロックされています.
     */
    public boolean isLock() {
        return this.lock ;
    }
    
}

