/*
 * @(#)JRcProtocolDef.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer ;

/**
 * JRcServerプロトコル.
 *  
 * @version 2006/09/10
 * @author  masahito suzuki
 * @since   JRcServerBase 1.00
 */
public class JRcProtocolDef {
    
    /**
     * プロトコルヘッダ数.
     */
    public static final int HEADER_LENGTH = 6 ;
    
    /**
     * JRcServerデフォルトポート番号.
     */
    public static final int DEFAULT_JRCSERVER_PORT = 32109 ;
    
    /**
     * JRcServerデフォルトタイムアウト値.
     */
    public static final int DEFAULT_JRCSERVER_TIMEOUT = 300000 ;
    
    /**
     * 送信プロトコルヘッダ数.
     */
    public static final int SEND_HEADER_LENGTH = HEADER_LENGTH ;
    
    /**
     * 送信プロトコルヘッダ.
     */
    public static final byte[] SEND_HEADER = {
        ( byte )0x0000004a,( byte )0x00000052,( byte )0x00000063,
        ( byte )0x00000023,( byte )0x00000073,( byte )0x0000002d
    } ;
    
    /**
     * 受信プロトコルヘッダ数.
     */
    public static final int RCV_HEADER_LENGTH = HEADER_LENGTH ;
    
    /**
     * 最低受信プロトコルサイズ.
     */
    public static final int MIN_RCV_PROTOCOL_LENGTH = RCV_HEADER_LENGTH + 4 + 8 + 4 ;
    
    /**
     * 受信プロトコルヘッダ.
     */
    public static final byte[] RCV_HEADER = {
        ( byte )0x0000004a,( byte )0x00000052,( byte )0x00000063,
        ( byte )0x00000023,( byte )0x00000072,( byte )0x0000002b
    } ;
    
    /**
     * コンストラクタ.
     */
    private JRcProtocolDef() {
        
    }
}

