/*
 * @(#)JRcErrorCodeDef.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer ;

/**
 * JRcServerエラーコード.
 *  
 * @version 2006/09/10
 * @author  masahito suzuki
 * @since   JRcServerBase 1.00
 */
public class JRcErrorCodeDef {
    
    /**
     * エラーコード : その他例外.
     */
    public static final int ERROR_ETC = JRcResultDef.ERROR ;
    
    /**
     * エラーコード : 受信タイムアウトが発生.
     */
    public static final int ERROR_TIMEOUT = JRcResultDef.ERROR | 1 ;
    
    /**
     * エラーコード : プロトコル不正.
     */
    public static final int ERROR_NOT_PROTOCOL = JRcResultDef.ERROR | 2 ;
    
    /**
     * エラーコード : アプリケーション名が存在しない.
     */
    public static final int ERROR_NOT_APPLICATION_NAME = JRcResultDef.ERROR | 3 ;
    
    /**
     * エラーコード : コマンド名が存在しない.
     */
    public static final int ERROR_NOT_COMMAND_NAME = JRcResultDef.ERROR | 4 ;
    
    /**
     * エラーコード : パラメータ名が不正.
     */
    public static final int ERROR_NOT_PARAMETER_NAME = JRcResultDef.ERROR | 5 ;
    
    /**
     * エラーコード : パラメータデータが不正.
     */
    public static final int ERROR_NOT_PARAMETER_DATA = JRcResultDef.ERROR | 6 ;
    
    /**
     * エラーコード : コマンド処理中にエラー.
     */
    public static final int ERROR_EXECUTION_COMMAND = JRcResultDef.ERROR | 7 ;
    
    /**
     * ワーニングコード : 登録されているサービスは0件.
     */
    public static final int WARNING_ZERO_SERVICE = JRcResultDef.WARNING | 8 ;
    
    /**
     * エラーコード : 指定サービス名は存在しないか不正.
     */
    public static final int ERROR_NOT_SERVICE = JRcResultDef.ERROR | 9 ;
    
    
    /**
     * コンストラクタ.
     */
    private JRcErrorCodeDef() {
        
    }
}

