/*
 * @(#)NotUseSectorException.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer ;

import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.BaseException;


/**
 * Java-Remote-Comand例外.
 *  
 * @version 2006/08/18
 * @author  masahito suzuki
 * @since   JRcServerBase 1.00
 */
public class JRCommandException extends AccessException {
    
    /**
     * エラーコード.
     */
    protected int errorCode = JRcResultDef.ERROR ;
    
    /**
     * コンタストラクタ.
     */
    public JRCommandException() {
        super() ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public JRCommandException(Throwable e) {
        super(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param e スローエラー対象の例外を設定します。
     */
    public JRCommandException(BaseException e) {
        super(e) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param   message スローエラー生成時のメッセージを設定します。
     */
    public JRCommandException(String message) {
        
        super(message) ;
        
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param errorCode 対象のエラーコードを設定します.
     * @param e スローエラー対象の例外を設定します。
     */
    public JRCommandException(int errorCode,Throwable e) {
        super(e) ;
        this.setErrorCode( errorCode ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時に発生原因のExceptionを設定します.
     * <BR>
     * @param errorCode 対象のエラーコードを設定します.
     * @param e スローエラー対象の例外を設定します。
     */
    public JRCommandException(int errorCode,BaseException e) {
        super(e) ;
        this.setErrorCode( errorCode ) ;
    }
    
    /**
     * コンタストラクタ.
     * <BR><BR>
     * オブジェクト生成と同時にメッセージを設定します.
     * <BR>
     * @param errorCode 対象のエラーコードを設定します.
     * @param message スローエラー生成時のメッセージを設定します。
     */
    public JRCommandException(int errorCode,String message) {
        super(message) ;
        this.setErrorCode( errorCode ) ;
    }
    
    /**
     * エラーコードを設定.
     * <BR><BR>
     * エラーコードを設定します.
     * <BR>
     * @param errorCode エラーコードを設定します.
     */
    public void setErrorCode( int errorCode ) {
        this.errorCode = ( errorCode & (~JRcResultDef.STATE_MASK) ) | JRcResultDef.ERROR ;
    }
    
    /**
     * エラーコード取得.
     * <BR><BR>
     * 対象エラーコードを取得します.
     * <BR>
     * @return int エラーコードが返されます.
     */
    public int getErrorCode() {
        return this.errorCode ;
    }
}
