/*
 * @(#)JRcContorolServer
 *
 * Copyright (c) 2003 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.server.control ;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * JRcServerリモートシャットダウン
 *  
 * @version 2006/09/16
 * @author  masahito suzuki
 * @since   JRcServerAPI 1.00
 */
public class JRcRemoteShutdown {
    
    /**
     * ログオブジェクト.
     */
    private static final Log LOG = LogFactory.getLog( JRcRemoteShutdown.class ) ;
    
    /**
     * シャットダウン命令回数.
     */
    private static final int SEND_COUNT = 10 ;
    
    /**
     * コンストラクタ.
     */
    private JRcRemoteShutdown() {
        
    }
    
    /**
     * メインメソッド.
     * <BR><BR>
     * @param args 引数を設定します.
     */
    public static final void main( String[] args ) {
        new JRcRemoteShutdown().execution( args ) ;
    }
    
    /**
     * 実行処理.
     */
    private void execution( String[] args ) {
        
        int i ;
        int len ;
        
        JRcRemoteControlClient client = null ;
        
        try {
            
            client = new JRcRemoteControlClient() ;
            if( args == null ) {
                
                System.err.println( "引数が必要です" ) ;
                System.err.println( " " ) ;
                System.err.println( " java JRcRemoteShutdown [addr] [port]" ) ;
                System.err.println( "   java JRcRemoteShutdown : コマンド名." ) ;
                System.err.println( "   addr                   : 接続先アドレス." ) ;
                System.err.println( "   port                   : 接続先ポート." ) ;
                System.err.println( " " ) ;
                System.err.println( " 対象条件のJRcServerをシャットダウンします." ) ;
                System.err.println( " port は省略可能です." ) ;
                System.err.println( " " ) ;
                
                return ;
            }
            
            LOG.info( "JRcServer シャットダウン処理を実施 - 開始" ) ;
            
            if( args.length == 1 ) {
                
                client.create( args[ 0 ] ) ;
                
            }
            else {
                
                client.create( args[ 0 ],Integer.parseInt( args[ 1 ] ) ) ;
                
            }
            
            len = SEND_COUNT ;
            
            for( i = 0 ; i < len ; i ++ ) {
                
                client.remoteShutdown() ;
                
            }
            
            LOG.info( "JRcServer シャットダウン処理を実施 - 終了" ) ;
            
        } catch( Exception e ) {
            LOG.error( "JRcServer シャットダウン処理を実施 - 終了",e ) ;
        }
        
    }
    
}
