/*
 * @(#)JRcContorolServer
 *
 * Copyright (c) 2003 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.server.control ;

import com.JRcServer.commons.exception.ConvertException;
import com.JRcServer.commons.exception.InputException;

/**
 * JRcServerリモートコントロール定義.
 *  
 * @version 2006/09/13
 * @author  masahito suzuki
 * @since   JRcServerAPI 1.00
 */
public class JRcRemoteControlDef {
    
    /**
     * デフォルトリモートコントロールポート番号.
     */
    public static final int DEF_PORT = 32108 ;
    
    /**
     * リモートモード : ノーマル.
     */
    public static final int DEF_REMOTE = 0x00000000 ;
    
    /**
     * リモートモード : 受信エラー.
     */
    public static final int REMOTE_ERROR = 0x80000001 ;
    
    /**
     * リモートモード : 受信タイムアウト.
     */
    public static final int REMOTE_TIMEOUT = 0x40000002 ;
    
    /**
     * リモートモード : シャットダウン実施.
     */
    public static final int REMOTE_SHUTDOWN = 0x00000001 ;
    
    /**
     * リモートヘッダ.
     */
    private static final byte[] REMOTE_HEADER = {
        ( byte )0x00000071,( byte )0x0000000e } ;
    
    
    
    /**
     * リモートモードを、バイナリに変換.
     * <BR><BR>
     * リモートモードを、バイナリに変換します.
     * <BR>
     * @param mode 変換対象のリモートモードを設定します.
     * @return byte[] 変換されたバイナリ情報が返されます.
     */
    public static final byte[] convertRemoteModeByBinary( int mode ) {
        
        byte[] ret = null ;
        
        ret = new byte[ 6 ] ;
        ret[ 5 ] = ( byte )( mode & 0x000000ff ) ;
        ret[ 4 ] = ( byte )JRcRemoteControlDef.REMOTE_HEADER[ 0 ] ;
        ret[ 3 ] = ( byte )( ( mode & 0x0000ff00 ) >> 8 ) ;
        ret[ 2 ] = ( byte )( ( mode & 0x00ff0000 ) >> 16 ) ;
        ret[ 1 ] = ( byte )( ( mode & 0xff000000 ) >> 24 ) ;
        ret[ 0 ] = ( byte )JRcRemoteControlDef.REMOTE_HEADER[ 1 ] ;
        
        return ret ;
        
    }
    
    /**
     * バイナリをリモートモードに変換.
     * <BR><BR>
     * バイナリを、リモートモードに変換します.
     * <BR>
     * @param mode リモートモードに変換するバイナリを設定します.
     * @return int 変換されたリモートモードが返されます.
     * @exception InputException 入力例外.
     */
    public static final int convertBinaryByRemoteMode( byte[] mode )
        throws InputException,ConvertException {
        
        int ret ;
        
        if( mode.length != 6 ){
            throw new InputException( "引数は不正です" ) ;
        }
        else if(
            mode[ 4 ] != JRcRemoteControlDef.REMOTE_HEADER[ 0 ] ||
            mode[ 0 ] != JRcRemoteControlDef.REMOTE_HEADER[ 1 ]
        )
        {
            throw new ConvertException(
                "この電文はRemoteMode電文ではありません"
            ) ;
        }
        
        ret = ( int )(
            ( mode[ 5 ] & 0x000000ff ) |
            ( ( mode[ 3 ] & 0x000000ff ) << 8 ) |
            ( ( mode[ 2 ] & 0x000000ff ) << 16 ) |
            ( ( mode[ 1 ] & 0x000000ff ) << 24 )
        ) ;
        
        return ret ;
        
    }
    
}
