/*
 * @(#)SerializableSession.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.server ;

import java.io.Serializable;

/**
 * シリアライズセッションインターフェイス.
 *  
 * @version 2006/09/06
 * @author  masahito suzuki
 * @since   JRcServerAPI 1.00
 */
public interface SerializableSession extends Serializable {
    
    /**
     * セッション初期化処理.
     * <BR><BR>
     * セッション初期化処理を行います.<BR>
     * この処理はオブジェクトがシリアライズから復帰した後に実施する
     * 必要があります.
     * <BR>
     * @return boolean 処理結果が返されます.<BR>
     *                 [true]が返された場合、セッション情報は正しく再構成されました.<BR>
     *                 [false]が返された場合、セッション情報は正しく再構成されませんでした.
     */
    public boolean initSession() ;
    
    /**
     * セッション終了処理.
     * <BR><BR>
     * セッション終了処理を実施します.<BR>
     * この処理はオブジェクトがシリアライズする前に実施する
     * 必要があります.
     * <BR>
     * @return boolean シリアライズが可能であるか返されます.<BR>
     *                 [true]が返された場合、シリアライズ可能です.<BR>
     *                 [false]が返された場合、シリアライズ不可能です.
     */
    public boolean exitSession() ;
    
}

