/*
 * @(#)JRcSessionManager.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.server ;

import com.JRcServer.JRcSession;

/**
 * JRcServerセッションマネージャ.
 *  
 * @version 2006/09/06
 * @author  masahito suzuki
 * @since   JRcServerAPI 1.00
 */
public interface JRcSessionManager {
    
    /**
     * 新しいセッションオブジェクトを取得.
     * <BR><BR>
     * 新しいセッションオブジェクトを取得します.
     * <BR>
     * @param applicationName 対象のアプリケーション名を設定します.
     * @return JRcSession セッションオブジェクトが返されます.
     */
    public JRcSession createSession( String applicationName ) ;
    
    /**
     * セッションオブジェクトを削除.
     * <BR><BR>
     * セッションオブジェクトを削除します.
     * <BR>
     * @param applicationName 削除対象のアプリケーション名を設定します.
     * @param sessionID 削除対象のセッションIDを設定します.
     */
    public void removeSession( String applicationName,long sessionID ) ;
    
    /**
     * セッションオブジェクトを削除.
     * <BR><BR>
     * セッションオブジェクトを削除します.
     * <BR>
     * @param session 削除対象のセッションオブジェクトを設定します.
     */
    public void removeSession( JRcSession session ) ;
    
    /**
     * セッションオブジェクトを取得.
     * <BR><BR>
     * セッションオブジェクトを取得します.
     * <BR>
     * @param applicationName 対象のアプリケーション名を設定します.
     * @param sessionID 対象のセッションIDを設定します.
     * @return JRcSession セッションオブジェクトが返されます.
     */
    public JRcSession getSession( String applicationName,long sessionID ) ;
    
    /**
     * セッション情報数を取得.
     * <BR><BR>
     * 管理されているセッション数を取得します.
     * <BR>
     * @return int セッション情報数が返されます.
     */
    public int size() ;
    
    /**
     * セッションタイムアウト値を変更.
     * <BR><BR>
     * 現在のセッションタイムアウト値を変更します.
     * <BR>
     * @param sessionTimeout 変更対象のセッションタイムアウト値を設定します.
     */
    public void setSessionTimeout( long sessionTimeout ) ;
    
    /**
     * 設定されているセッションタイムアウト値を取得.
     * <BR><BR>
     * 設定されているセッションタイムアウト値を取得します.
     * <BR>
     * @return long 設定されているセッションタイムアウト値が返されます.
     */
    public long getSessionTimeout() ;
    
    /**
     * セッションIDが存在するかチェック.
     * <BR><BR>
     * 指定したセッションIDが管理情報に存在するかチェックします.
     * <BR>
     * @param sessionID 対象のセッションIDを設定します.
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、セッションIDは存在します.<BR>
     *                 [false]が返された場合、セッションIDは存在しません.
     */
    public boolean isSessionID( long sessionID ) ;
    
    /**
     * セッション管理マネージャが有効かチェック.
     * <BR><BR>
     * セッション管理マネージャが有効であるかチェックします.
     * <BR>
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、セッション管理マネージャは有効です.<BR>
     *                 [false]が返された場合、セッション管理マネージャは無効です.
     */
    public boolean isSessionManager() ;
    
}

