/*
 * @(#)JRcServerShutdown.java
 *
 * Copyright (c) 2004 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.server ;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.sys.Initializer;

/**
 * JRcServerシャットダウンフック.
 * <BR><BR>
 * JRcServerシャットダウンフック処理を実施します.
 *  
 * @version 2006/09/13
 * @author  masahito suzuki
 * @since   JRcServerAPI-1.00
 */
public class JRcServerShutdownHook extends Thread {
    
    /**
     * ログオブジェクト.
     */
    private static final Log LOG = LogFactory.getLog( JRcServerShutdownHook.class ) ;
    
    /**
     * 初期化オブジェクト.
     */
    private Initializer initObject = null ;
    
    /**
     * シャットダウンフックを登録.
     * <BR><BR>
     * シャットダウンフックを登録します.
     * <BR>
     * @param init 初期化オブジェクトを設定します.
     * @exception InputException 入力例外.
     */
    public static final void registShutdownHook( Initializer init )
        throws InputException {
        
        Initializer jrcinit = null ;
        
        if( init == null ) {
            throw new InputException( "引数は不正です" ) ;
        }
        else if( ( init instanceof InitJRcServer ) == false ) {
            jrcinit = new InitJRcServer( init ) ;
        }
        else {
            jrcinit = init ;
        }
        
        // シャットダウンフックに終了処理を登録.
        Runtime.getRuntime().addShutdownHook(
            new JRcServerShutdownHook( jrcinit )
        ) ;
        
    }
    
    
    /**
     * コンストラクタ.
     */
    private JRcServerShutdownHook( Initializer init ) {
        
        
        this.setPriority( Thread.MAX_PRIORITY ) ;
        this.setDaemon( false ) ;
        
        this.initObject = init ;
    }
    
    /**
     * シャットダウンフック.
     */
    public final void run() {
        
        LOG.info (
            "## [JRcServer]シャットダウンフックを開始します"
        ) ;
        
        // シャットダウン処理を実施.
        try{
            initObject.destroy() ;
        }catch( Exception e ){
        }
        
        LOG.info (
            "## [JRcServer]シャットダウンフックを終了します"
        ) ;
        
    }
    
}

