/*
 * @(#)JRcConnectServer.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.server ;

import java.net.InetAddress;

import com.JRcServer.JRcProtocolDef;

/**
 * JRcServerサーバネットワークインターフェイス.
 * <BR><BR>
 * JRcServerネットワークサーバインターフェイスです.
 *  
 * @version 2006/09/10
 * @author  masahito suzuki
 * @since   JRcServerAPI 1.00
 */
public interface JRcConnectServer {
    
    /**
     * バインドポートデフォルト値.
     */
    public static final int DEFAULT_BIND_PORT = JRcProtocolDef.DEFAULT_JRCSERVER_PORT ;
    
    /**
     * デフォルトタイムアウト値.
     */
    public static final int DEFAULT_TIMEOUT = JRcProtocolDef.DEFAULT_JRCSERVER_TIMEOUT ;
    
    /**
     * デフォルト最大コネクション数.
     */
    public static final int DEFAULT_MAX_CONNECTION = 50 ;
    
    
    
    /**
     * 現在コネクション中の数を取得.
     * <BR><BR>
     * 現在コネクション中の数が返されます.
     * <BR>
     * @return int 現在コネクション中の数が返されます.
     */
    public int getConnectionCount() ;
    
    /**
     * バインド先アドレスを取得.
     * <BR><BR>
     * バインド先アドレスを取得します.
     * <BR>
     * @return InetAddress バインド先アドレスが返されます.
     */
    public InetAddress getBindAddress() ;
    
    /**
     * バインド先ポート番号を取得.
     * <BR><BR>
     * バインド先ポート番号を取得します.
     * <BR>
     * @return int バインド先ポート番号が返されます.
     */
    public int getBindPort() ;
    
    /**
     * コネクション制限数を取得.
     * <BR><BR>
     * コネクション制限数を取得します.
     * <BR>
     * @return int コネクション制限数が返されます.
     */
    public int getMaxConnectCount() ;
    
    /**
     * コネクションタイムアウト値を取得.
     * <BR><BR>
     * コネクションタイムアウト値を取得します.
     * <BR>
     * @return int コネクションタイムアウト値が返されます.
     */
    public int getConnectTimeout() ;
    
    /**
     * サーバオブジェクトが有効であるかチェック.
     * <BR><BR>
     * サーバオブジェクトが有効であるかチェックします.
     * <BR>
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、有効です.<BR>
     *                 [false]が返された場合、無効です.
     */
    public boolean isServer() ;
    
}

