/*
 * @(#)JRcCache.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.server ;

import com.JRcServer.commons.resource.ResourceType;
import com.JRcServer.commons.resource.cache.CacheDef;
import com.JRcServer.commons.resource.cache.CacheIO;

/**
 * JRcServerキャッシュインターフェイス.
 * <BR><BR>
 * JRcServerキャッシュ情報を持つインターフェイスです.
 *  
 * @version 2006/09/07
 * @author  masahito suzuki
 * @since   JRcServerAPI 1.00
 */
public interface JRcCache {
    
    /**
     * キャッシュサイズデフォルト値.
     */
    public static final int DEFAULT_CHACHE_LENGTH = CacheDef.MAX_SECTOR / 4 ;
    
    /**
     * キャッシュ名を取得.
     * <BR><BR>
     * キャッシュ名を取得します.
     * <BR>
     * @return String キャッシュ名を取得します.
     */
    public String getName() ;
    
    /**
     * キャッシュIDを取得.
     * <BR><BR>
     * キャッシュIDを取得します.
     * <BR>
     * @return long キャッシュIDが返されます.
     */
    public long getID() ;
    
    /**
     * キャッシュファイル名を取得.
     * <BR><BR>
     * キャッシュファイル名を取得します.
     * <BR>
     * @return String キャッシュファイル名が返されます.
     */
    public String getFileName() ;
    
    /**
     * キャッシュセクタサイズを取得.
     * <BR><BR>
     * キャッシュセクタサイズを取得します.
     * <BR>
     * @return int キャッシュセクタサイズを取得します.
     */
    public int getCacheSize() ;
    
    /**
     * 現在利用中のキャッシュセクタサイズを取得.
     * <BR><BR>
     * 現在利用中のキャッシュセクタサイズを取得します.
     * <BR>
     * @return int 現在利用中のキャッシュセクタサイズが返されます.
     */
    public int getUseCacheSize() ;
    
    /**
     * 利用比率[%]を取得.
     * <BR><BR>
     * 利用比率[%]を取得します.
     * <BR>
     * @return int 利用比率[0-100]%をが整数で返されます.<BR>
     *             仮に70%の利用状況の場合[70]の整数が返されます.
     */
    public int getCachePersent() ;
    
    /**
     * キャッシュリソースタイプを取得.
     * <BR><BR>
     * キャッシュリソースタイプを取得します.
     * <BR>
     * @return ResourceType キャッシュリソースタイプが返されます.
     */
    public ResourceType getResourceType() ;
    
    /**
     * キャッシュI/Oオブジェクトを取得.
     * <BR><BR>
     * キャッシュI/Oオブジェクトを取得します.
     * <BR>
     * @return CacheIO キャッシュI/Oオブジェクトが返されます.
     */
    public CacheIO getCacheIO() ;
    
    /**
     * キャッシュオブジェクトが有効かチェック.
     * <BR><BR>
     * キャッシュオブジェクトが有効であるかチェックします.
     * <BR>
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、有効です.<BR>
     *                 [false]が返された場合、無効です.
     */
    public boolean isCache() ;
    
}

