/*
 * @(#)JRcBaseManager.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.server ;

import java.net.InetAddress;

import com.JRcServer.DeleteSessionTrigger;
import com.JRcServer.JRcService;

/**
 * JRcServer基本マネージャ.
 * <BR><BR>
 * JRcServer基本マネージャインターフェイス.
 *  
 * @version 2006/09/07
 * @author  masahito suzuki
 * @since   JRcServerAPI 1.00
 */
public interface JRcBaseManager {
    
    /**
     * キャッシュオブジェクトを取得.
     * <BR><BR>
     * キャッシュオブジェクトを取得します.
     * <BR>
     * @return JRcCache キャッシュオブジェクトが返されます.
     */
    public JRcCache getCache() ;
    
    /**
     * セッションマネージャオブジェクトを取得.
     * <BR><BR>
     * セッションマネージャオブジェクトを取得します.
     * <BR>
     * @return JRcSessionManager セッションマネージャオブジェクトが返されます.
     */
    public JRcSessionManager getSessionManager() ;
    
    /**
     * 基本ディレクトリ名を取得.
     * <BR><BR>
     * 基本ディレクトリ名を取得します.
     * <BR>
     * @return String 基本ディレクトリ名が返されます.
     */
    public String getBaseDirectory() ;
    
    /**
     * バインドアドレスを取得.
     * <BR><BR>
     * バインドアドレスを取得します.
     * <BR>
     * @return InetAddress バインドアドレスが返されます.
     */
    public InetAddress getInetAddress() ;
    
    /**
     * バインドポート番号を取得.
     * <BR><BR>
     * バインドポート番号を取得します.
     * <BR>
     * @return int バインドポート番号が返されます.
     */
    public int getBindPort() ;
    
    /**
     * コールバックオブジェクトを取得.
     * <BR><BR>
     * セッション削除時に呼び出されるコールバックオブジェクトを取得します.
     * <BR>
     * @return DeleteSessionTrigger コールバックオブジェクトが返されます.
     */
    public DeleteSessionTrigger getCallback() ;
    
    /**
     * オプションオブジェクトを取得.
     * <BR><BR>
     * 設定されているオプションオブジェクトを取得します.
     * <BR>
     * @return Object オプションオブジェクトが返されます.
     */
    public Object getOption() ;
    
    /**
     * コネクションサーバオブジェクトを取得.
     * <BR><BR>
     * コネクションサーバオブジェクトを取得します.
     * <BR>
     * @return JRcConnectServer コネクションサーバオブジェクトが返されます.
     */
    public JRcConnectServer getConnectServer() ;
    
    /**
     * サービス管理オブジェクトを取得.
     * <BR><BR>
     * サービス管理オブジェクトを取得します.
     * <BR>
     * @return JRcService サービスオブジェクトが返されます.
     */
    public JRcService getServer() ;
    
    /**
     * ステータス情報を設定.
     * <BR><BR>
     * ステータス情報を設定します.
     * <BR>
     * @param state 対象のステータスを設定します.
     */
    public void setState( int state ) ;
    
    /**
     * ステータス情報を取得.
     * <BR><BR>
     * ステータス情報を取得します.
     * <BR>
     * @return int ステータス情報が返されます.
     */
    public int getState() ;
    
}

