/*
 * @(#)JRcSession.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer ;

import com.JRcServer.commons.exception.InputException;

/**
 * JRcServerセッションインターフェイス.
 *  
 * @version 2006/09/06
 * @author  masahito suzuki
 * @since   JRcServerAPI 1.00
 */
public interface JRcSession {
    
    /**
     * デフォルトタイムアウト値.
     */
    public static final long DEF_SESSION_TIMEOUT = 1800000L ;
    
    /**
     * セッションタイムアウト : 最小値.
     */
    public static final long MIN_SESSION_TIMEOUT = 300000L ;
    
    /**
     * セッションタイムアウト : 最大値.
     */
    public static final long MAX_SESSION_TIMEOUT = 172800000L ;
    
    /**
     * 要素を追加.
     * <BR><BR>
     * 要素を追加します.
     * <BR>
     * @param name 追加対象の要素名を設定します.
     * @param value 要素情報を設定します.
     * @exception InputException 引数が不正な場合.
     */
    public void putValue( String name,Object value )
        throws InputException ;
    
    /**
     * 要素情報を削除.
     * <BR><BR>
     * 要素を削除します.
     * <BR>
     * @param name 削除対象の要素名を設定します.
     * @exception InputException 引数が不正な場合.
     */
    public void removeValue( String name )
        throws InputException ;
    
    /**
     * 要素を取得.
     * <BR><BR>
     * 要素を取得します.
     * <BR>
     * @param name 取得対象の要素名を設定します.
     * @return Object 要素情報が返されます.
     */
    public Object getValue( String name ) ;
    
    /**
     * 登録されている要素名群を取得.
     * <BR><BR>
     * 登録されている要素名群を取得します.
     * <BR>
     * @return String[] 登録されている要素名群が返されます.
     */
    public String[] getNames() ;
    
    /**
     * 登録されている要素数を取得.
     * <BR><BR>
     * 登録されている要素数を取得します.
     * <BR>
     * @return int 登録されている要素数が返されます.
     */
    public int size() ;
    
    /**
     * アプリケーション名を取得.
     * <BR><BR>
     * アプリケーション名を取得します.
     * <BR>
     * @return String アプリケーション名が返されます.
     */
    public String getApplicationName() ;
    
    /**
     * セッションIDを取得.
     * <BR><BR>
     * セッションIDを取得します.
     * <BR>
     * @return long セッションIDが返されます.
     */
    public long getId() ;
    
    /**
     * セッション生成時間を取得.
     * <BR><BR>
     * セッション生成の時間を取得します.
     * <BR>
     * @return long セッションが生成された時間が返されます.
     */
    public long getCreateTime() ;
    
    /**
     * ラストアクセス時間を取得.
     * <BR><BR>
     * ラストアクセス時間を取得します.
     * <BR>
     * @return long ラストアクセス時間が返されます.
     */
    public long getLastAccessTime() ;
    
    /**
     * セッションタイムアウトを取得.
     * <BR><BR>
     * セッションタイムアウトを取得します.
     * <BR>
     * @return long セッションのタイムアウト時間が返されます.
     */
    public long getSessionTimeout() ;
    
    /**
     * 最後にリクエストされた時間からセッションタイムアウトする
     * までの時間を取得.
     * <BR><BR>
     * 最後にリクエストされた時間からセッションタイムアウトする
     * までの時間を取得します.
     * <BR>
     * @return long 最後にリクエストされた時間からの
     *              セッションタイムアウト値が返されます.
     */
    public long getTimeoutRemainder() ;
    
    /**
     * セッション情報が有効であるかチェック.
     * <BR><BR>
     * このセッション情報が有効であるかチェックします.
     * <BR>
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、セッションは有効です.<BR>
     *                 [false]が返された場合、セッションは無効です.
     */
    public boolean isSession() ;
    
}

