/*
 * @(#)JRcService.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer ;

import com.JRcServer.JRCommand;

/**
 * JRcServerサービスインターフェイス.
 * <BR><BR>
 * JRcServerサービスを表すインターフェイスです.<BR>
 * このインターフェイスを継承して、JRcServerで提供する
 * サービスを定義します.<BR>
 * またこのサービスをJRcServerとして有効にする場合は、<BR>
 * <PRE>
 *    JRcService service = new xxxx() ;
 *    JRcBaseDefineBean bean = new JRcBaseDefineBean() ;
 *    bean.setService( service ) ;
 *             ・
 *             ・
 *             ・
 *    JRcManagerFactory.initJRcBeanManager( bean ) ;
 * </PRE>
 * のような形で定義することで、有効となります.<BR>
 * つまり、上記の場合では、serviceインターフェイスに対して、提供したい<BR>
 * サービス群を管理するxxxxオブジェクトをインスタンス化し、その内容を<BR>
 * beanに登録して、JRcManagerFactoryを初期化することで、独自のJRcServerを<BR>
 * 提供することが可能となります.
 * 
 * @version 2006/09/08
 * @author  masahito suzuki
 * @since   JRcServerAPI 1.00
 */
public interface JRcService {
    
    /**
     * コモンサービス : サービスリスト一覧.
     */
    public static final String COMMON_SERVICE_LIST = "list" ;
    
    /**
     * コモンサービス : サーババージョン.
     */
    public static final String COMMON_SERVER_VERSION = "version" ;
    
    /**
     * コモンサービス : ヘルプ.
     */
    public static final String COMMON_SERVICE_HELP = "help" ;
    
    /**
     * コモンサービス : ヘルプサービス名パラメータ引数.
     */
    public static final String COMMON_SERVICE_PARAM_HELP = "command" ;
    
    
    /**
     * このサービスを管理するサーババージョンを取得.
     * <BR><BR>
     * このサービスを管理するサーババージョンを取得します.
     * <BR>
     * @return String サービスサーババージョンが返されます.
     */
    public String getServerVersion() ;
    
    /**
     * 対象サービスから、JRCommandを取得.
     * <BR><BR>
     * 対象サービスから、JRCommandを取得します.
     * <BR>
     * @param name 対象のサービス名を設定します.
     * @return JRCommand 対象のコマンド情報が返されます.
     */
    public JRCommand getService( String name ) ;
    
    /**
     * 有効サービス名一覧を取得.
     * <BR><BR>
     * 有効サービス名一覧を取得します.
     * <BR>
     * @return String[] 有効サービス名一覧が返されます.
     */
    public String[] getServiceNames() ;
    
    /**
     * 有効サービス数を取得.
     * <BR><BR>
     * 有効となるサービス数を取得します.
     * <BR>
     * @return int 有効サービス数が返されます.
     */
    public int getServerSize() ;
    
    /**
     * サービス名が存在するかチェック.
     * <BR><BR>
     * サービス名が存在するかチェックします.
     * <BR>
     * @param name チェック対象のサービス名を設定します.
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]を設定した場合、存在します.<BR>
     *                 [false]を設定した場合、存在しません.
     */
    public boolean isService( String name ) ;
    
}

