/*
 * @(#)JRcResponse.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer ;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

/**
 * JRcServerレスポンスインターフェイス.
 *  
 * @version 2006/09/06
 * @author  masahito suzuki
 * @since   JRcServerAPI 1.00
 */
public interface JRcResponse {
    
    /**
     * セッションIDを取得.
     * <BR><BR>
     * セッションIDを取得します.
     * <BR>
     * @return long セッションIDが返されます.
     */
    public long getSessionID() ;
    
    /**
     * キャラクタセットを設定.
     * <BR><BR>
     * キャラクタセットを設定します.
     * <BR>
     * @param charset 対象のキャラクタセットを設定します.
     */
    public void setCharset( String charset ) ;
    
    /**
     * キャラクタセットを取得.
     * <BR><BR>
     * キャラクタセットを取得します.
     * <BR>
     * @return String キャラクタセットが返されます.
     */
    public String getCharset() ;
    
    /**
     * Mimeタイプを設定.
     * <BR><BR>
     * Mimeタイプを設定します.
     * <BR>
     * @param mimeType 対象のMimeタイプを設定します.
     */
    public void setMimeType( String mimeType ) ;
    
    /**
     * Mimeタイプを取得.
     * <BR><BR>
     * Mimeタイプを取得します.
     * <BR>
     * @return String Mimeタイプが返されます.
     */
    public String getMimeType() ;
    
    /**
     * レスポンスにバイナリデータを出力する際に
     * 使用するOutputStreamを取得.
     * <BR><BR>
     * レスポンスにバイナリデータを出力する際に
     * 使用するOutputStreamを取得します.
     * <BR>
     * @return OutputStream バイナリデータに出力する
     *                      OutputStreamが返されます.
     * @exception IOException I/O例外.
     */
    public OutputStream getOutputStream() throws IOException ;
    
    /**
     * 文字データをクライアントに送り返すのに
     * 使用するPrintWriterオブジェクトを取得.
     * <BR><BR>
     * 文字データをクライアントに送り返すのに
     * 使用するPrintWriterオブジェクトを取得します.
     * <BR>
     * @return PrintWriter クライアントに文字データを送り返すことが
     *                     できるPrintWriterオブジェクトが返されます.
     * @exception IOException I/O例外.
     */
    public PrintWriter getWriter() throws IOException ;
    
    /**
     * データモードを取得.
     * <BR><BR>
     * 確定しているデータモードを取得します.
     * <BR>
     * @return boolean 確定しているデータモードが返されます.<BR>
     *                 [true]が返された場合、文字情報として送られます.<BR>
     *                 [false]が返された場合、バイナリ情報として送られます.
     */
    public boolean isMode() ;
    
    /**
     * 正常戻り値を設定.
     * <BR><BR>
     * 正常戻り値を設定します.
     * <BR>
     * @param result 正常戻り値を設定します.
     */
    public void setSuccess( int result ) ;
    
    /**
     * 警告戻り値を設定.
     * <BR><BR>
     * 警告戻り値を設定します.
     * <BR>
     * @param result 警告戻り値を設定します.
     */
    public void setWarning( int result ) ;
    
    /**
     * 異常戻り値を設定.
     * <BR><BR>
     * 異常戻り値を設定します.
     * <BR>
     * @param result 異常戻り値を設定します.
     */
    public void setError( int result ) ;
    
    /**
     * 異常戻り値を設定.
     * <BR><BR>
     * 異常戻り値を設定します.
     * <BR>
     * @param result 異常戻り値を設定します.
     * @param message 異常メッセージを設定します.
     */
    public void setError( int result,String message ) ;
    
    /**
     * 復旧不能異常戻り値を設定.
     * <BR><BR>
     * 復旧不能異常戻り値を設定します.
     * <BR>
     * @param result 復旧不能異常戻り値を設定します.
     */
    public void setFatalError( int result ) ;
    
    /**
     * 復旧不能異常戻り値を設定.
     * <BR><BR>
     * 復旧不能異常戻り値を設定します.
     * <BR>
     * @param result 復旧不能異常戻り値を設定します.
     * @param message 復旧不能異常メッセージを設定します.
     */
    public void setFatalError( int result,String message ) ;
    
    /**
     * 設定されている戻り値を取得.
     * <BR><BR>
     * 設定されている戻り値を取得します.
     * <BR>
     * @return int 設定されている戻り値が返されます.
     */
    public int getResult() ;
    
    /**
     * 設定されている戻りメッセージを取得.
     * <BR><BR>
     * 設定されている戻りメッセージを取得します.
     * <BR>
     * @return String 設定されている戻りメッセージが返されます.
     */
    public String getResultMessage() ;
    
}

