/*
 * @(#)JRcBaseDefineBean.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer ;

import java.net.InetAddress;

import com.JRcServer.commons.beans.BaseBean;
import com.JRcServer.commons.serialize.SerializeUtil;
import com.JRcServer.server.JRcCache;
import com.JRcServer.server.JRcConnectServer;

/**
 * JRcServer基本マネージャ定義Bean.
 * <BR><BR>
 * JRcServer基本マネージャ定義Beanです.<BR>
 * このオブジェクトは、JRcServer基本マネージャの<BR>
 * 起動オプションを定義するためのオブジェクトです.
 * 
 * @version 2006/09/07
 * @author  Masahito Suzuki
 * @since   JRcServerAPI 1.00
 */
public class JRcBaseDefineBean implements BaseBean {
    
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            JRcBaseDefineBean.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    
    
    /**
     * 基本ディレクトリ名.
     */
    private String baseDirectory = null ;
    
    /**
     * キャッシュサイズ.
     */
    private int cacheSize = JRcCache.DEFAULT_CHACHE_LENGTH ;
    
    /**
     * セッションタイムアウト.
     */
    private long sessionTimeout = JRcSession.DEF_SESSION_TIMEOUT ;
    
    /**
     * バインドアドレス.
     */
    private InetAddress bindAddress = null ;
    
    /**
     * バインドポート番号.
     */
    private int bindPort = JRcConnectServer.DEFAULT_BIND_PORT ;
    
    /**
     * セッション削除時のコールバックメソッド.
     */
    private DeleteSessionTrigger callback = null ;
    
    /**
     * サービス管理オブジェクト.
     */
    private JRcService service = null ;
    
    /**
     * 通信受信タイムアウト.
     */
    private int receiveTimeout = JRcConnectServer.DEFAULT_TIMEOUT ;
    
    /**
     * コネクション最大接続数.
     */
    private int maxConnect = JRcConnectServer.DEFAULT_MAX_CONNECTION ;
    
    /**
     * オプションオブジェクト.
     */
    private Object option = null ;
    
    
    /**
     * コンストラクタ.
     */
    public JRcBaseDefineBean() {
        
    }
    
    /**
     * baseDirectory を取得.
     * <BR><BR>
     * @return baseDirectory が返されます.
     */
    public String getBaseDirectory() {
        return baseDirectory;
    }
    
    /**
     * baseDirectory を設定.
     * <BR><BR>
     * @param baseDirectory baseDirectory を設定します.
     */
    public void setBaseDirectory(String baseDirectory) {
        this.baseDirectory = baseDirectory;
    }
    
    /**
     * cacheSize を取得.
     * <BR><BR>
     * @return cacheSize が返されます.
     */
    public int getCacheSize() {
        return cacheSize;
    }
    
    /**
     * cacheSize を設定.
     * <BR><BR>
     * @param cacheSize cacheSize を設定します.
     */
    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }
    
    /**
     * sessionTimeout を取得.
     * <BR><BR>
     * @return sessionTimeout が返されます.
     */
    public long getSessionTimeout() {
        return sessionTimeout;
    }
    
    /**
     * sessionTimeout を設定.
     * <BR><BR>
     * @param sessionTimeout sessionTimeout を設定します.
     */
    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }
    
    /**
     * bindAddress を取得.
     * <BR><BR>
     * @return bindAddress が返されます.
     */
    public InetAddress getBindAddress() {
        return bindAddress;
    }
    
    /**
     * bindAddress を設定.
     * <BR><BR>
     * @param bindAddress bindAddress を設定します.
     */
    public void setBindAddress(InetAddress bindAddress) {
        this.bindAddress = bindAddress;
    }
    
    /**
     * bindPort を取得.
     * <BR><BR>
     * @return bindPort が返されます.
     */
    public int getBindPort() {
        return bindPort;
    }
    
    /**
     * bindPort を設定.
     * <BR><BR>
     * @param bindPort bindPort を設定します.
     */
    public void setBindPort(int bindPort) {
        this.bindPort = bindPort;
    }
    
    /**
     * callback を取得.
     * <BR><BR>
     * @return callback が返されます.
     */
    public DeleteSessionTrigger getCallback() {
        return callback;
    }
    
    /**
     * callback を設定.
     * <BR><BR>
     * @param callback callback を設定します.
     */
    public void setCallback(DeleteSessionTrigger callback) {
        this.callback = callback;
    }
    
    /**
     * receiveTimeout を取得.
     * <BR><BR>
     * @return receiveTimeout が返されます.
     */
    public int getReceiveTimeout() {
        return receiveTimeout;
    }
    
    /**
     * receiveTimeout を設定.
     * <BR><BR>
     * @param receiveTimeout receiveTimeout を設定します.
     */
    public void setReceiveTimeout(int receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }
    
    /**
     * maxConnect を取得.
     * <BR><BR>
     * @return maxConnect が返されます.
     */
    public int getMaxConnect() {
        return maxConnect;
    }
    
    /**
     * maxConnect を設定.
     * <BR><BR>
     * @param maxConnect maxConnect を設定します.
     */
    public void setMaxConnect(int maxConnect) {
        this.maxConnect = maxConnect;
    }
    
    /**
     * service を取得.
     * <BR><BR>
     * @return service が返されます.
     */
    public JRcService getService() {
        return service;
    }
    
    /**
     * service を設定.
     * <BR><BR>
     * @param service service を設定します.
     */
    public void setService(JRcService service) {
        this.service = service;
    }
    
    /**
     * option を取得.
     * <BR><BR>
     * @return option が返されます.
     */
    public Object getOption() {
        return option;
    }
    
    /**
     * option を設定.
     * <BR><BR>
     * @param option option を設定します.
     */
    public void setOption(Object option) {
        this.option = option;
    }
    
    /**
     * オブジェクトを文字列に変換.
     * <BR><BR>
     * オブジェクトを文字列に変換します.
     * <BR>
     * @return String 文字列が返されます.
     */
    public String toString() {
        
        return new StringBuffer().
            append( "baseDirectory:" ).
            append( baseDirectory ).
            append( " cacheSize:" ).
            append( cacheSize ).
            append( " sessionTimeout:" ).
            append( sessionTimeout ).
            append( " bindAddress:" ).
            append( ( ( bindAddress == null ) ? "null" : bindAddress.getHostAddress() ) ).
            append( " bindPort:" ).
            append( bindPort ).
            append( " callback:" ).
            append( callback ).
            append( " service:" ).
            append( service ).
            append( " receiveTimeout:" ).
            append( receiveTimeout ).
            append( " maxConnect;" ).
            append( maxConnect ).
            append( " option:" ).
            append( option ).
            toString() ;
        
    }
}

