/*
 * @(#)JRCommand.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer ;

import java.io.PrintWriter;

/**
 * JRcServerコマンドインターフェイス.
 *  
 * @version 2006/08/18
 * @author  masahito suzuki
 * @since   JRcServerAPI 1.00
 */
public interface JRCommand {
    
    /**
     * コマンド.
     * <BR><BR>
     * コマンド実行された場合に呼び出されるメソッド.
     * <BR>
     * @param request リクエスト情報が設定されます.
     * @param response レスポンス情報が設定されます.
     * @exception JRCommandException コマンド実行例外.
     */
    public void execution( JRcRequest request,JRcResponse response )
        throws JRCommandException ;
    
    /**
     * コマンドヘルプ情報取得.
     * <BR><BR>
     * コマンドヘルプ情報を取得します.
     * <BR>
     * @param writer コマンドヘルプ情報が返されます.
     */
    public void getHelp( PrintWriter writer ) ;
    
}

