/*
 * @(#)DeleteSessionTrigger.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer ;

/**
 * セッション削除時に起動するコールバック.
 * <BR><BR>
 * セッションタイムアウトによるセッション削除時に呼び出される
 * コールバックインターフェイス.
 *  
 * @version 2006/09/07
 * @author  masahito suzuki
 * @since   JRcServerAPI 1.00
 */
public interface DeleteSessionTrigger {
    
    /**
     * セッション削除時に呼び出されるコールバックメソッド.
     * <BR><BR>
     * セッションタイムアウト等で起動するコールバックメソッドです.
     * <BR>
     * @param applicationName 削除されるアプリケーション名が設定されます.
     * @param sessionID 削除されるセッションIDが設定されます.
     */
    public void callback( String applicationName,long sessionID ) ;
    
    
}

