/*
 * @(#)JRCommand.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer ;

import java.io.PrintWriter;

/**
 * JRcServerコマンドアブストラクトクラス.
 * <BR><BR>
 * ヘルプ表示をサポートしない場合などの、JRcCommandを作成する場合、
 * このオブジェクトを継承してください。
 * 
 * @version 2006/09/09
 * @author  masahito suzuki
 * @since   JRcServerAPI 1.00
 */
public abstract class AbstractJRCommand implements JRCommand {
    
    /**
     * コマンド.
     * <BR><BR>
     * コマンド実行された場合に呼び出されるメソッド.
     * <BR>
     * @param request リクエスト情報が設定されます.
     * @param response レスポンス情報が設定されます.
     * @exception JRCommandException コマンド実行例外.
     */
    public abstract void execution( JRcRequest request,JRcResponse response )
        throws JRCommandException ;
    
    /**
     * コマンドヘルプ情報取得.
     * <BR><BR>
     * コマンドヘルプ情報を取得します.
     * <BR>
     * @param writer コマンドヘルプ情報が返されます.
     */
    public void getHelp( PrintWriter writer ) {
        
        writer.print( JRcResultDef.NOT_HELP ) ;
        
    }
    
}

