/*
 * @(#)BaseBox.java
 *
 * Copyright (c) 2003 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.util.box;

import java.io.Serializable;

import com.JRcServer.commons.exception.InputException;

/**
 * 基本ボックスインターフェイス.
 * <BR><BR>
 * 基本ボックスインターフェイスを提供します.
 *
 * @version     1.00, 2004/11/22
 * @author      Masahito Suzuki
 * @since  JRcCommons 1.00
 */
public interface BaseBox extends Serializable
{
    
    /**
     * 情報生成.
     * <BR><BR>
     * 格納対象情報を設定します.
     * <BR>
     * @param size 生成対象サイズを設定します.
     * @exception InputException 入力例外.
     */
    public void create( int size ) throws InputException ;
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public void clear() ;
    
    /**
     * 領域を追加.
     * <BR><BR>
     * 領域を追加します.
     * <BR>
     * @param size 追加対象のサイズを設定します.
     * @return int 追加された後の全体サイズが返されます.
     */
    public int addSpace( int size ) ;
    
    /**
     * 領域を削除.
     * <BR><BR>
     * 領域を削除します.
     * <BR>
     * @param size 削除対象のサイズを設定します.
     * @return int 削除された後の全体サイズが返されます.
     */
    public int removeSpace( int size ) ;
    
    /**
     * 管理要素長を取得.
     * <BR><BR>
     * 管理要素長を取得します.
     * <BR>
     * @return int 管理要素長が返されます.
     */
    public int getMaxSize() ;
    
    /**
     * 利用中の要素長を取得.
     * <BR><BR>
     * 現在利用されている要素長を取得します.
     * <BR>
     * @return int 利用要素長が返されます.
     */
    public int getUseSize() ;
    
    /**
     * 情報存在チェック.
     * <BR><BR>
     * 対象要素位置に情報が存在しているかチェックします.
     * <BR>
     * @param no チェック対象の要素項番を設定します.
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、要素情報は存在します.
     *                 [false]が返された場合、要素情報は存在しません.
     */
    public boolean isData( int no ) ;
}

