/*
 * @(#)Roll.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.util ;

/**
 * ロールインターフェイス.
 * <BR><BR>
 * ロール管理を行うインターフェイスです.
 *
 * @version     1.00, 2005/07/28
 * @author      Masahito Suzuki
 * @since  JRcCommons 1.00
 */
public interface Roll
{
    
    /**
     * オブジェクト破棄.
     * <BR><BR>
     * オブジェクトを破棄します.
     */
    public void destroy() ;
    
    /**
     * 追加予約をONにセット.
     * <BR><BR>
     * 追加予約をONにセットします.
     */
    public void addReservationByON() ;
    
    /**
     * 追加予約をOFFにセット.
     * <BR><BR>
     * 追加予約をOFFにセットします.
     */
    public void addReservationByOFF() ;
    
    /**
     * 対象の管理サイズを取得.
     * <BR><BR>
     * 対象の管理サイズが返されます.
     * <BR>
     * @return int 管理サイズが返されます.
     */
    public int getMax() ;
    
    /**
     * 現在の格納数を取得.
     * <BR><BR>
     * 現在の格納数を取得します.
     * <BR>
     * @return int 現在の格納数が返されます.
     */
    public int getSize() ;
    
    /**
     * データが追加できるかチェック.
     * <BR><BR>
     * データが追加できるかチェックします.
     * <BR>
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、設定可能です.<BR>
     *                 [false]が返された場合、ロールは満杯のため設定はできません.
     */
    public boolean isAdd() ;
    
    /**
     * 追加予約が行われているかチェック.
     * <BR><BR>
     * 追加予約が行われているかチェックします.
     * <BR>
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、追加予約されています.<BR>
     *                 [false]が返された場合追加予約はされていません.
     */
    public boolean isAddReservation() ;
    
}

