/*
 * @(#)ReadIndex.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.util;

import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.InputException;

/**
 * インデックス情報.
 * <BR><BR>
 * インデックス情報を管理するインターフェイスを提供します.
 *
 * @version     1.00, 2004/05/01
 * @author      Masahito Suzuki
 * @since  JRcCommons 1.00
 */
public interface ReadIndex
{
    
    /**
     * インデックスなし状態.
     */
    public static final int NOT_INDEX = -1 ;
    
    /**
     * インデックス情報の取得.
     * <BR><BR>
     * インデックス情報を取得します.
     * <BR>
     * @param no 取得対象のインデックス位置を設定します.
     * @return Object インデックス位置に対する情報が返されます.
     * @exception InputException 入力例外.
     * @exception AccessException アクセス例外.
     */
    public Object getIndex( int no )
        throws InputException,AccessException ;
    
    /**
     * 管理インデックス数の取得.
     * <BR><BR>
     * 管理しているインデックス数を取得します.
     * <BR>
     * @return int 管理インデックス数が返されます.<BR>
     *             情報が存在しない場合[ReadIndex.NOT_INDEX]が返されます.
     */
    public int size() ;
    
    /**
     * インデックス利用可能状態チェック.
     * <BR><BR>
     * インデックス情報が利用可能かチェックします.
     * <BR>
     * @return boolean チェック結果が返されます.<BR>
     *                 [true]が返された場合、インデックスは利用可能です.
     *                 [false]が返された場合、インデックスは利用不可能です.
     */
    public boolean isIndex() ;
    
}
