/** 
 * @(#)KanaZenToHan.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.util;

/**
 * 全角半角カナ相互変換.
 *
 * @version 2006/08/02
 * @author  masahito suzuki
 * @since   JRcCommons 1.00
 */
public class KanaZenToHan {
    
    
    
    /**
     * 全角半角カナ文字コードを変換.
     * <BR><BR>
     * 全角から半角や、半角から全角のカナ文字を変換します.
     * <BR>
     * @param mode 変換オプションを設定します.<BR>
     *             [true]を設定した場合、全角から半角に変換します.<BR>
     *             [false]を設定した場合、半角から全角に変換します.
     * @param string 変換対象の文字列を設定します.
     * @return String 変換された文字列が返されます.
     */
    public static final String convert( boolean mode,String string ) {
        
        int i ;
        int len ;
        
        boolean[] ch = null ;
        String one = null ;
        StringBuffer buf = null ;
        
        if ( string == null || ( len = string.length() ) <= 0 ) {
            if ( string != null ) {
                return "" ;
            }
            return null ;
        }
        
        ch = new boolean[ 1 ] ;
        ch[ 0 ] = false ;
        
        buf = new StringBuffer() ;
        
        for ( i = 0 ; i < len ; i ++ ) {
            
            if ( ch[ 0 ] == true ) {
                
                ch[ 0 ] = false ;
                continue ;
                
            }
            else {
                
                if ( mode == true ) {
                    one = KanaZenToHan.zenToHan( string,i ) ;
                    if ( one == null ) {
                        buf.append( string.charAt( i ) ) ;
                    }
                    else {
                        buf.append( one ) ;
                    }
                }
                else {
                    one = KanaZenToHan.hanToZen( ch,string,i ) ;
                    if ( one == null ) {
                        buf.append( string.charAt( i ) ) ;
                    }
                    else {
                        buf.append( one ) ;
                    }
                }
                
            }
            
        }
        
        return buf.toString() ;
        
    }
    
    /**
     * 全角から半角変換
     */
    private static final String zenToHan( String str,int index ) {
        
        char code ;
        
        try {
            
            code = str.charAt( index ) ;
            
            switch( code ) {
                case 'ァ' : return "ｧ" ;
                case 'ィ' : return "ｨ" ;
                case 'ゥ' : return "ｩ" ;
                case 'ェ' : return "ｪ" ;
                case 'ォ' : return "ｫ" ;
                case 'ャ' : return "ｬ" ;
                case 'ュ' : return "ｭ" ;
                case 'ョ' : return "ｮ" ;
                case 'ッ' : return "ｯ" ;
                case 'ー' : return "ｰ" ;
                case 'ア' : return "ｱ" ;
                case 'イ' : return "ｲ" ;
                case 'ウ' : return "ｳ" ;
                case 'エ' : return "ｴ" ;
                case 'オ' : return "ｵ" ;
                case 'カ' : return "ｶ" ;
                case 'キ' : return "ｷ" ;
                case 'ク' : return "ｸ" ;
                case 'ケ' : return "ｹ" ;
                case 'コ' : return "ｺ" ;
                case 'サ' : return "ｻ" ;
                case 'シ' : return "ｼ" ;
                case 'ス' : return "ｽ" ;
                case 'セ' : return "ｾ" ;
                case 'ソ' : return "ｿ" ;
                case 'タ' : return "ﾀ" ;
                case 'チ' : return "ﾁ" ;
                case 'ツ' : return "ﾂ" ;
                case 'テ' : return "ﾃ" ;
                case 'ト' : return "ﾄ" ;
                case 'ナ' : return "ﾅ" ;
                case 'ニ' : return "ﾆ" ;
                case 'ヌ' : return "ﾇ" ;
                case 'ネ' : return "ﾈ" ;
                case 'ノ' : return "ﾉ" ;
                case 'ハ' : return "ﾊ" ;
                case 'ヒ' : return "ﾋ" ;
                case 'フ' : return "ﾌ" ;
                case 'ヘ' : return "ﾍ" ;
                case 'ホ' : return "ﾎ" ;
                case 'マ' : return "ﾏ" ;
                case 'ミ' : return "ﾐ" ;
                case 'ム' : return "ﾑ" ;
                case 'メ' : return "ﾒ" ;
                case 'モ' : return "ﾓ" ;
                case 'ヤ' : return "ﾔ" ;
                case 'ユ' : return "ﾕ" ;
                case 'ヨ' : return "ﾖ" ;
                case 'ラ' : return "ﾗ" ;
                case 'リ' : return "ﾘ" ;
                case 'ル' : return "ﾙ" ;
                case 'レ' : return "ﾚ" ;
                case 'ロ' : return "ﾛ" ;
                case 'ワ' : return "ﾜ" ;
                case 'ヲ' : return "ｦ" ;
                case 'ン' : return "ﾝ" ;
                case 'ガ' : return "ｶﾞ" ;
                case 'ギ' : return "ｷﾞ" ;
                case 'グ' : return "ｸﾞ" ;
                case 'ゲ' : return "ｹﾞ" ;
                case 'ゴ' : return "ｺﾞ" ;
                case 'ザ' : return "ｻﾞ" ;
                case 'ジ' : return "ｼﾞ" ;
                case 'ズ' : return "ｽﾞ" ;
                case 'ゼ' : return "ｾﾞ" ;
                case 'ゾ' : return "ｿﾞ" ;
                case 'ダ' : return "ﾀﾞ" ;
                case 'ヂ' : return "ﾁﾞ" ;
                case 'ヅ' : return "ﾂﾞ" ;
                case 'デ' : return "ﾃﾞ" ;
                case 'ド' : return "ﾄﾞ" ;
                case 'パ' : return "ﾊﾟ" ;
                case 'ピ' : return "ﾋﾟ" ;
                case 'プ' : return "ﾌﾟ" ;
                case 'ペ' : return "ﾍﾟ" ;
                case 'ポ' : return "ﾎﾟ" ;
                case 'バ' : return "ﾊﾞ" ;
                case 'ビ' : return "ﾋﾞ" ;
                case 'ブ' : return "ﾌﾞ" ;
                case 'ベ' : return "ﾍﾞ" ;
                case 'ボ' : return "ﾎﾞ" ;
                case 'ヴ' : return "ｳﾞ" ;
                
            }
            
        } catch( Exception e ) {
        }
        
        return null ;
    }
    
    /**
     * 半角から全角変換.
     */
    private static final String hanToZen( boolean[] out,String str,int index ) {
        
        int type ;
        char code ;
        char code2 ;
        
        out[ 0 ] = false ;
        
        try {
            
            code = str.charAt( index ) ;
            
            if( index + 1 >= str.length() ){
                
                switch( code ) {
                    case 'ｧ' : return "ァ" ;
                    case 'ｨ' : return "ィ" ;
                    case 'ｩ' : return "ゥ" ;
                    case 'ｪ' : return "ェ" ;
                    case 'ｫ' : return "ォ" ;
                    case 'ｬ' : return "ャ" ;
                    case 'ｭ' : return "ュ" ;
                    case 'ｮ' : return "ョ" ;
                    case 'ｯ' : return "ッ" ;
                    case 'ｰ' : return "ー" ;
                    case 'ｱ' : return "ア" ;
                    case 'ｲ' : return "イ" ;
                    case 'ｳ' : return "ウ" ;
                    case 'ｴ' : return "エ" ;
                    case 'ｵ' : return "オ" ;
                    case 'ｶ' : return "カ" ;
                    case 'ｷ' : return "キ" ;
                    case 'ｸ' : return "ク" ;
                    case 'ｹ' : return "ケ" ;
                    case 'ｺ' : return "コ" ;
                    case 'ｻ' : return "サ" ;
                    case 'ｼ' : return "シ" ;
                    case 'ｽ' : return "ス" ;
                    case 'ｾ' : return "セ" ;
                    case 'ｿ' : return "ソ" ;
                    case 'ﾀ' : return "タ" ;
                    case 'ﾁ' : return "チ" ;
                    case 'ﾂ' : return "ツ" ;
                    case 'ﾃ' : return "テ" ;
                    case 'ﾄ' : return "ト" ;
                    case 'ﾅ' : return "ナ" ;
                    case 'ﾆ' : return "ニ" ;
                    case 'ﾇ' : return "ヌ" ;
                    case 'ﾈ' : return "ネ" ;
                    case 'ﾉ' : return "ノ" ;
                    case 'ﾊ' : return "ハ" ;
                    case 'ﾋ' : return "ヒ" ;
                    case 'ﾌ' : return "フ" ;
                    case 'ﾍ' : return "ヘ" ;
                    case 'ﾎ' : return "ホ" ;
                    case 'ﾏ' : return "マ" ;
                    case 'ﾐ' : return "ミ" ;
                    case 'ﾑ' : return "ム" ;
                    case 'ﾒ' : return "メ" ;
                    case 'ﾓ' : return "モ" ;
                    case 'ﾔ' : return "ヤ" ;
                    case 'ﾕ' : return "ユ" ;
                    case 'ﾖ' : return "ヨ" ;
                    case 'ﾗ' : return "ラ" ;
                    case 'ﾘ' : return "リ" ;
                    case 'ﾙ' : return "ル" ;
                    case 'ﾚ' : return "レ" ;
                    case 'ﾛ' : return "ロ" ;
                    case 'ﾜ' : return "ワ" ;
                    case 'ｦ' : return "ヲ" ;
                    case 'ﾝ' : return "ン" ;
                    
                }
                
            }
            else {
                
                type = 0 ;
                code2 = str.charAt( index+1 ) ;
                if( code2 == 'ﾞ' ){
                    type = 1 ;
                }
                else if( code2 == 'ﾟ' ){
                    type = 2 ;
                }
                
                switch( code ) {
                    case 'ｧ' : return "ァ" ;
                    case 'ｨ' : return "ィ" ;
                    case 'ｩ' : return "ゥ" ;
                    case 'ｪ' : return "ェ" ;
                    case 'ｫ' : return "ォ" ;
                    case 'ｬ' : return "ャ" ;
                    case 'ｭ' : return "ュ" ;
                    case 'ｮ' : return "ョ" ;
                    case 'ｯ' : return "ッ" ;
                    case 'ｰ' : return "ー" ;
                    case 'ｱ' : return "ア" ;
                    case 'ｲ' : return "イ" ;
                    case 'ｳ' :
                        if( type == 1 ) {
                            out[ 0 ] = true ;
                            return "ヴ" ;
                        }
                        else{
                            return "ウ" ;
                        }
                    case 'ｴ' : return "エ" ;
                    case 'ｵ' : return "オ" ;
                    case 'ｶ' :
                        if( type == 1 ) {
                            out[ 0 ] = true ;
                            return "ガ" ;
                        }
                        else{
                            return "カ" ;
                        }
                    case 'ｷ' :
                        if( type == 1 ) {
                            out[ 0 ] = true ;
                            return "ギ" ;
                        }
                        else {
                            return "キ" ;
                        }
                    case 'ｸ' :
                        if( type == 1 ) {
                            out[ 0 ] = true ;
                            return "グ" ;
                        }
                        else {
                            return "ク" ;
                        }
                    case 'ｹ' :
                        if( type == 1 ) {
                            out[ 0 ] = true ;
                            return "ゲ" ;
                        }
                        else {
                            return "ケ" ;
                        }
                    case 'ｺ' :
                        if( type == 1 ) {
                            out[ 0 ] = true ;
                            return "ゴ" ;
                        }
                        else {
                            return "コ" ;
                        }
                    case 'ｻ' :
                        if( type == 1 ) {
                            out[ 0 ] = true ;
                            return "ザ" ;
                        }
                        else{
                            return "サ" ;
                        }
                    case 'ｼ' :
                        if( type == 1 ) {
                            out[ 0 ] = true ;
                            return "ジ" ;
                        }
                        else{
                            return "シ" ;
                        }
                    case 'ｽ' :
                        if( type == 1 ) {
                            out[ 0 ] = true ;
                            return "ズ" ;
                        }
                        else{
                            return "ス" ;
                        }
                    case 'ｾ' :
                        if( type == 1 ) {
                            out[ 0 ] = true ;
                            return "ゼ" ;
                        }
                        else{
                            return "セ" ;
                        }
                    case 'ｿ' :
                        if( type == 1 ) {
                            out[ 0 ] = true ;
                            return "ゾ" ;
                        }
                        else{
                            return "ソ" ;
                        }
                    case 'ﾀ' :
                        if( type == 1 ) {
                            out[ 0 ] = true ;
                            return "ダ" ;
                        }
                        else{
                            return "タ" ;
                        }
                    case 'ﾁ' :
                        if( type == 1 ) {
                            out[ 0 ] = true ;
                            return "ヂ" ;
                        }
                        else{
                            return "チ" ;
                        }
                    case 'ﾂ' :
                        if( type == 1 ) {
                            out[ 0 ] = true ;
                            return "ヅ" ;
                        }
                        else{
                            return "ツ" ;
                        }
                    case 'ﾃ' :
                        if( type == 1 ) {
                            out[ 0 ] = true ;
                            return "デ" ;
                        }
                        else{
                            return "テ" ;
                        }
                    case 'ﾄ' :
                        if( type == 1 ) {
                            out[ 0 ] = true ;
                            return "ド" ;
                        }
                        else{
                            return "ト" ;
                        }
                    case 'ﾅ' : return "ナ" ;
                    case 'ﾆ' : return "ニ" ;
                    case 'ﾇ' : return "ヌ" ;
                    case 'ﾈ' : return "ネ" ;
                    case 'ﾉ' : return "ノ" ;
                    case 'ﾊ' :
                        if( type == 1 ) {
                            out[ 0 ] = true ;
                            return "バ" ;
                        }
                        else if( type == 2 ) {
                            out[ 0 ] = true ;
                            return "パ" ;
                        }
                        else{
                            return "ハ" ;
                        }
                    case 'ﾋ' :
                        if( type == 1 ) {
                            out[ 0 ] = true ;
                            return "ビ" ;
                        }
                        else if( type == 2 ) {
                            out[ 0 ] = true ;
                            return "ピ" ;
                        }
                        else{
                            return "ヒ" ;
                        }
                    case 'ﾌ' :
                        if( type == 1 ) {
                            out[ 0 ] = true ;
                            return "ブ" ;
                        }
                        else if( type == 2 ) {
                            out[ 0 ] = true ;
                            return "プ" ;
                        }
                        else{
                            return "フ" ;
                        }
                    case 'ﾍ' :
                        if( type == 1 ) {
                            out[ 0 ] = true ;
                            return "ベ" ;
                        }
                        else if( type == 2 ) {
                            out[ 0 ] = true ;
                            return "ペ" ;
                        }
                        else{
                            return "ヘ" ;
                        }
                    case 'ﾎ' :
                        if( type == 1 ) {
                            out[ 0 ] = true ;
                            return "ボ" ;
                        }
                        else if( type == 2 ) {
                            out[ 0 ] = true ;
                            return "ポ" ;
                        }
                        else{
                            return "ホ" ;
                        }
                    case 'ﾏ' : return "マ" ;
                    case 'ﾐ' : return "ミ" ;
                    case 'ﾑ' : return "ム" ;
                    case 'ﾒ' : return "メ" ;
                    case 'ﾓ' : return "モ" ;
                    case 'ﾔ' : return "ヤ" ;
                    case 'ﾕ' : return "ユ" ;
                    case 'ﾖ' : return "ヨ" ;
                    case 'ﾗ' : return "ラ" ;
                    case 'ﾘ' : return "リ" ;
                    case 'ﾙ' : return "ル" ;
                    case 'ﾚ' : return "レ" ;
                    case 'ﾛ' : return "ロ" ;
                    case 'ﾜ' : return "ワ" ;
                    case 'ｦ' : return "ヲ" ;
                    case 'ﾝ' : return "ン" ;
                    
                }
                
            }
            
        } catch( Exception e ) {
        }
        
        return null ;
    }
    
}

