/*
 * @(#)DoubleTableSync.java
 *
 * Copyright (c) 2005 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.util;

/**
 * DoubleTableSyncオブジェクト.
 * <BR><BR>
 * float( double )情報を同期モードで管理するオブジェクトです.<BR>
 * このオブジェクトは同期モードです.<BR>
 * このオブジェクトは、非同期モード[NumberTable]オブジェクトに比べて
 * 約１５％ほど動作がおそくなりますが、スレッド間アクセスを行った場合、内容は保証
 * されます.<BR>
 * 非同期モードのオブジェクトは[DoubleTable]オブジェクトを利用してください.
 *
 * @version 1.00, 2000/12/09
 * @author  Masahito Suzuki
 * @since  JRcCommons 1.00
 */
public class DoubleTableSync
{
    /**
     * データ管理オブジェクト.
     */
    private CoreDoubleTable m_info = null ;
    
    /**
     * コンストラクタ.
     */
    public DoubleTableSync()
    {
        m_info = new CoreDoubleTable() ;
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 検索コードを指定して生成します.
     * <BR>
     * @param searchNo 検索コードを設定します.<BR>
     *                 設定可能な最小値は[0]です.<BR>
     *                 設定可能な最大値は[7]です.
     */
    public DoubleTableSync( int searchNo )
    {
        m_info = new CoreDoubleTable( searchNo ) ;
    }
    
    /**
     * ファイナライズ処理定義.
     * <BR><BR>
     * ファイナライズ処理定義.
     * @exception Exception 例外処理が返されます.
     */
    protected final void finalize() throws Exception
    {
        
        try{
            this.clear() ;
        }catch( Exception t ){
        }
        
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public synchronized final void clear()
    {
        m_info.clear() ;
    }
    
    /**
     * 情報の追加.
     * <BR><BR>
     * 管理オブジェクトに小数点列を追加します.
     * <BR>
     * @param num 追加対象の小数点情報を設定します.<BR>
     *             すでに同一情報が存在する場合、上書きします.
     * @param value 追加対象の要素情報を設定します.
     */
    public synchronized final void add( double num,Object value )
    {
        m_info.add( num,value ) ;
    }
    
    /**
     * 指定情報の削除.
     * <BR><BR>
     * 指定された情報を削除します.
     * <BR>
     * @param num 削除対象の小数点情報を指定します.
     * @return Object 削除された情報の要素が返されます.
     */
    public synchronized final Object remove( double num )
    {
        Object ret = null ;
        
        ret = m_info.remove( num ) ;
        
        return ret ;
    }
    
    /**
     * 情報取得.
     * <BR><BR>
     * 指定小数点列の情報を取得します.
     * <BR>
     * @param num 取得対象の小数点情報を指定します.
     * @return Object 取得された情報の要素が返されます.
     */
    public synchronized final Object get( double num )
    {
        return m_info.get( num ) ;
    }
    
    /**
     * 小数点に対する存在チェック.
     * <BR><BR>
     * 小数点に対する存在チェックを行います.
     * <BR>
     * @param num チェック対象の小数点を設定します.
     * @return boolean 存在結果が返されます.<BR>
     *                 [true]が返された場合、情報は存在します.<BR>
     *                 [false]が返された場合、情報は存在しません.
     */
    public synchronized final boolean isData( double num )
    {
        return m_info.isData( num ) ;
    }
    
    /**
     * 格納情報数の取得.
     * <BR><BR>
     * 格納情報数が返されます.
     * <BR>
     * @return int 格納情報数が返されます.
     */
    public synchronized final int size()
    {
        return m_info.size() ;
    }
    
    /**
     * 格納小数点配列の取得.
     * <BR><BR>
     * 格納されているキーとなる小数点をすべて取得します.
     * <BR>
     * @return double[] 格納小数点配列が返されます.<BR>
     *               情報が存在しない場合[null]が返されます.
     */
    public synchronized final double[] getNumbers()
    {
        return m_info.getNumbers() ;
    }
}
