/*
 * @(#)DoubleBigTableSync.java
 *
 * Copyright (c) 2003 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.util;

import java.io.Serializable;

import com.JRcServer.commons.serialize.SerializeUtil;

/**
 * DoubleBigTableSyncオブジェクト.
 * <BR><BR>
 * Number( long )情報を同期モードで管理するオブジェクトです.<BR>
 * このオブジェクトは同期モードです.<BR>
 * このオブジェクトは、非同期モード[BigTable]オブジェクトに比べて
 * 約１５％ほど動作がおそくなりますが、スレッド間アクセスを行った場合、内容は保証
 * されます.<BR>
 * 非同期モードのオブジェクトは[DoubleBigTable]オブジェクトを利用してください.
 *
 * @version 1.00, 2000/12/09
 * @author  Masahito Suzuki
 * @since  JRcCommons 1.00
 */
public class DoubleBigTableSync implements Serializable
{
    
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            DoubleBigTableSync.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    /**
     * データ管理オブジェクト.
     */
    private CoreDoubleBigTable m_info = null ;
    
    /**
     * コンストラクタ.
     */
    public DoubleBigTableSync()
    {
        m_info = new CoreDoubleBigTable() ;
    }
    
    /**
     * ファイナライズ処理定義.
     * <BR><BR>
     * ファイナライズ処理定義.
     * @exception Exception 例外処理が返されます.
     */
    protected final void finalize() throws Exception
    {
        
        try{
            this.clear() ;
        }catch( Exception t ){
        }
        
    }
    
    /**
     * 情報クリア.
     * <BR><BR>
     * 情報をクリアします.
     */
    public synchronized final void clear()
    {
        m_info.clear() ;
    }
    
    /**
     * 情報の追加.
     * <BR><BR>
     * 管理オブジェクトに数値列を追加します.
     * <BR>
     * @param key1 追加対象の１つ目の数値情報を設定します.<BR>
     *             すでに同一情報が存在する場合、上書きします.
     * @param key2 追加対象の２つ目の数値情報を設定します.<BR>
     *             すでに同一情報が存在する場合、上書きします.
     * @param value 追加対象の要素情報を設定します.
     */
    public synchronized final void add( long key1,long key2,Object value )
    {
        m_info.add( key1,key2,value ) ;
    }
    
    /**
     * 指定情報の削除.
     * <BR><BR>
     * 指定された情報を削除します.
     * <BR>
     * @param key1 削除対象の１つ目の数値情報を設定します.
     * @param key2 削除対象の２つ目の数値情報を設定します.
     * @return Object 削除された情報の要素が返されます.
     */
    public synchronized final Object remove( long key1,long key2 )
    {
        return m_info.remove( key1,key2 ) ;
    }
    
    /**
     * 情報取得.
     * <BR><BR>
     * 指定数値列の情報を取得します.
     * <BR>
     * @param key1 取得対象の１つ目の数値情報を設定します.
     * @param key2 取得対象の２つ目の数値情報を設定します.
     * @return Object 取得された情報の要素が返されます.
     */
    public synchronized final Object get( long key1,long key2 )
    {
        return m_info.get( key1,key2 ) ;
    }
    
    /**
     * 数値に対する存在チェック.
     * <BR><BR>
     * 数値に対する存在チェックを行います.
     * <BR>
     * @param key1 チェック対象の１つ目の数値情報を設定します.
     * @param key2 チェック対象の２つ目の数値情報を設定します.
     * @return boolean 存在結果が返されます.<BR>
     *                 [true]が返された場合、情報は存在します.<BR>
     *                 [false]が返された場合、情報は存在しません.
     */
    public synchronized final boolean isData( long key1,long key2 )
    {
        return m_info.isData( key1,key2 ) ;
    }
    
    /**
     * 格納情報数の取得.
     * <BR><BR>
     * 格納情報数が返されます.
     * <BR>
     * @return int 格納情報数が返されます.
     */
    public synchronized final int size()
    {
        return m_info.size() ;
    }
    
    /**
     * 格納数値配列の取得.
     * <BR><BR>
     * 格納されているキーとなる数値をすべて取得します.
     * <BR>
     * @return long[] 格納数値配列が返されます.<BR>
     *                格納されている偶数の情報が1つ目のキーです.<BR>
     *                格納されている奇数の情報が2つ目のキーです.<BR>
     *                情報が存在しない場合[null]が返されます.
     */
    public synchronized final long[] getNumbers()
    {
        return m_info.getNumbers() ;
    }
    
}
