/*
 * @(#)CoreDoubleBigTable.java
 *
 * Copyright (c) 2003 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.util;

import java.util.HashMap;



/**
 * CoreDoubleBigTableオブジェクト.
 * <BR><BR>
 * long情報をkey情報として管理するオブジェクトです.
 * また、このオブジェクトは内部オブジェクトです.
 *
 * @version 1.00, 2003/11/01
 * @author  Masahito Suzuki
 * @since  JRcCommons 1.00
 */
class CoreDoubleBigTable
{
    
    /**
     * 管理テーブル.
     */
    private final HashMap m_table = new HashMap() ;
    
    /**
     * コンストラクタ.
     */
    protected CoreDoubleBigTable()
    {
    }
    
    /**
     * ファイナライズ処理定義.
     * <BR><BR>
     * ファイナライズ処理定義.
     * @exception Exception 例外処理が返されます.
     */
    protected final void finalize() throws Exception
    {
        
        try{
            this.clear() ;
        }catch( Exception t ){
        }
        
    }
    
    /**
     * 情報クリア.
     */
    protected final void clear()
    {
        m_table.clear() ;
    }
    
    /**
     * 情報の追加.
     */
    protected final void add( long key1,long key2,Object value )
    {
        KeyDLong key = null ;
        
        key = new KeyDLong( key1,key2 ) ;
        m_table.put( key,value ) ;
    }
    
    /**
     * 指定情報の削除.
     */
    protected final Object remove( long key1,long key2 )
    {
        KeyDLong key = null ;
        
        key = new KeyDLong( key1,key2 ) ;
        return m_table.remove( key ) ;
    }
    
    /**
     * 情報取得.
     */
    protected final Object get( long key1,long key2 )
    {
        KeyDLong key = null ;
        
        key = new KeyDLong( key1,key2 ) ;
        return m_table.get( key ) ;
    }
    
    /**
     * 情報存在チェック.
     */
    protected final boolean isData( long key1,long key2 )
    {
        KeyDLong key = null ;
        
        key = new KeyDLong( key1,key2 ) ;
        return ( m_table.get( key ) == null ) ? false : true ;
    }
    
    /**
     * 格納情報数の取得.
     */
    protected final int size()
    {
        return m_table.size() ;
    }
    
    /**
     * 格納文字列配列の取得.
     */
    protected final long[] getNumbers()
    {
        int i,j ;
        int len ;
        Object[] objs = null ;
        KeyDLong key = null ;
        long[] ret = null ;
        
        if( m_table != null ){
            objs = m_table.keySet().toArray() ;
            if( objs != null ){
                len = objs.length ;
                ret = new long[ len * 2 ] ;
                for( i = 0,j = 0 ; i < len ; i ++,j += 2 ){
                    key = ( KeyDLong )objs[ i ] ;
                    ret[ j ] = key.getKey1() ;
                    ret[ j+1 ] = key.getKey2() ;
                }
                objs = null ;
            }
        }
        
        return ret ;
    }
}
