/*
 * @(#)CoreBigTable.java
 *
 * Copyright (c) 2003 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.util;

import java.io.Serializable;
import java.util.HashMap;

import com.JRcServer.commons.serialize.SerializeUtil;

/**
 * CoreBigTableオブジェクト.
 * <BR><BR>
 * long情報をkey情報として管理するオブジェクトです.
 * また、このオブジェクトは内部オブジェクトです.
 *
 * @version 1.00, 2003/11/01
 * @author  Masahito Suzuki
 * @since  JRcCommons 1.00
 */
class CoreBigTable implements Serializable
{
    
    static {
        serialVersionUID = SerializeUtil.serialVersionUID(
            CoreBigTable.class.getName()
        ) ;
    }
    
    /**
     * シリアライズUID.
     */
    private static final long serialVersionUID ;
    
    /**
     * データ格納テーブル.
     */
    private final HashMap m_table = new HashMap() ;
    
    
    /**
     * コンストラクタ.
     */
    protected CoreBigTable()
    {
    }
    
    /**
     * コンストラクタ.
     */
    protected CoreBigTable( int n )
    {
    }
    
    
    /**
     * ファイナライズ処理定義.
     * <BR><BR>
     * ファイナライズ処理定義.
     * @exception Exception 例外処理が返されます.
     */
    protected final void finalize() throws Exception
    {
        
        try{
            this.clear() ;
        }catch( Exception t ){
        }
        
    }
    
    /**
     * 情報クリア.
     */
    protected final void clear()
    {
        m_table.clear() ;
    }
    
    /**
     * 情報の追加.
     */
    protected final void add( long num,Object value )
    {
        Object inValue = null ;
        
        if( value == null ){
            inValue = new NullObject() ;
        }else{
            inValue = value ;
        }
        
        m_table.put( new Long( num ),inValue ) ;
        
        inValue = null ;
    }
    
    /**
     * 指定情報の削除.
     */
    protected final Object remove( long num )
    {
        Long in = null ;
        Object ret = null ;
        
        in = new Long( num ) ;
        ret = m_table.remove( in ) ;
        
        if( ret != null && ret instanceof NullObject ){
            ret = null ;
        }
        
        in = null ;
        
        return ret ;
    }
    
    /**
     * 情報取得.
     */
    protected final Object get( long num )
    {
        Long in = null ;
        Object ret = null ;
        
        in = new Long( num ) ;
        ret = m_table.get( in ) ;
        
        if( ret != null && ret instanceof NullObject ){
            ret = null ;
        }
        
        in = null ;
        
        return ret ;
    }
    
    /**
     * 情報存在チェック.
     */
    protected final boolean isData( long num )
    {
        boolean ret ;
        Long in = null ;
        
        in = new Long( num ) ;
        ret = ( m_table.get( in ) == null ) ? false : true ;
        
        in = null ;
        
        return ret ;
    }
    
    /**
     * 格納情報数の取得.
     */
    protected final int size()
    {
        return m_table.size() ;
    }
    
    /**
     * 格納文字列配列の取得.
     */
    protected final long[] getNumbers()
    {
        int i ;
        int len ;
        
        long[] ret = null ;
        Object[] obj = null ;
        
        obj = m_table.keySet().toArray() ;
        if( obj != null ){
            len = obj.length ;
            
            if( len <= 0 ){
                obj = null ;
                return null ;
            }
            
            ret = new long[ len ] ;
            
            for( i = 0 ; i < len ; i ++ ){
                ret[ i ] = ( ( Long )obj[ i ] ).longValue() ;
                obj[ i ] = null ;
            }
        }
        
        obj = null ;
        
        return ret ;
    }
    
}
