/*
 * @(#)ConvertBeam.java
 *
 * Copyright (c) 2006 masahito suzuki, Inc. All Rights Reserved
 */
package com.JRcServer.commons.util;

/**
 * 数値日本語桁変換.
 *
 * @version 2006/08/11
 * @author  Masahito Suzuki
 * @since   JRcCommons 1.00.
 */
public class ConvertBeam {
    
    /**
     * 桁文字(日本語).
     */
    private static final char[] BEAM_JP = {
        '万','億','兆','京'
    } ;
    
    /**
     * 桁位置.
     */
    private static final int[] BEAM_PNT = {
        4,8,12,16,20
    } ;
    
    
    
    /**
     * 数値桁変換(日本語).
     * <BR><BR>
     * 数値の桁変換(日本語)を行います.
     * <BR>
     * @param value 変換元の数値(long)を設定します.<BR>
     *              [-1 ～ -9223372036854775808]の値.
     *              [0 ～ 9223372036854775807]の値.
     * @return 変換された文字列が返されます.
     */
    public static final String convertJP( long value ) {
        
        int i ;
        int len ;
        int tmpInt ;
        
        int st,ed ;
        boolean minusFlg = false ;
        boolean endFlg = false ;
        
        String tmp = null ;
        String valueString = null ;
        String ret = null ;
        
        valueString = String.valueOf( value ) ;
        valueString = valueString.trim() ;
        
        if( valueString.startsWith( "-" ) == true ) {
            
            minusFlg = true ;
            valueString = valueString.substring( 1 ) ;
            
        }
        
        valueString = ConvertBeam.stringByContrary( valueString ) ;
        len = valueString.length() ;
        
        st = 0 ;
        
        for( i = 0,endFlg = false,ret = "" ; i <= BEAM_JP.length ; i ++ ) {
            
            ed = BEAM_PNT[ i ] ;
            
            if( len >= ed ) {
                
                tmp = valueString.substring( st,ed ) ;
                
            }
            else {
                
                tmp = valueString.substring( st ) ;
                endFlg = true ;
                
            }
            
            tmp = ConvertBeam.stringByContrary( tmp ) ;
            if( tmp == null || tmp.length() <= 0 ) {
                tmpInt = 0 ;
            }
            else{
                tmpInt = Integer.parseInt( tmp ) ;
            }
            
            if( tmpInt > 0 ) {
                
                tmp = String.valueOf( tmpInt ) ;
                
                
                if( i != 0 ) {
                    ret = new StringBuffer().
                        append( tmp ).
                        append( BEAM_JP[ i-1 ] ).
                        append( ret ).
                        toString() ;
                }
                else {
                    ret = tmp ;
                }
                
            }
            
            if( endFlg == true ) {
                break ;
            }
            
            st = ed ;
            
        }
        
        if( ret == null || ret.length() <= 0 ) {
            ret = String.valueOf( value ) ;
        }
        else if( minusFlg == true ) {
            ret = "-" + ret ;
        }
        
        return ret ;
        
    }
    
    /**
     * 文字列逆変換.
     */
    private static final String stringByContrary( String string ) {
        
        int i ;
        int len ;
        
        StringBuffer buf = null ;
        String ret = null ;
        
        len = string.length() ;
        
        if( len > 1 ) {
            
            buf = new StringBuffer() ;
            
            for( i = len-1 ; i >= 0 ; i -- ) {
                
                buf.append( string.charAt( i ) ) ;
                
            }
            
            ret = buf.toString() ;
            buf = null ;
            
        }
        else {
            
            ret = string ;
            
        }
        
        return ret ;
        
    }
}
